---
title: "v2.2.4 - It will be deleted soon"
date: 2021-04-01 23:08:00 +0900
categories:
  - Release
tags:
  - News
  - Release
head_inline: "<style> ul { padding-bottom: 1em; } .blue { color: blue; }</style>"
---

#### Bug Fixes
- [freeDiameter] A crash has been fixed when using a version prior to v2.2.3 ([#898](https://github.com/open5gs/open5gs/issues/898)) -- [Nour963](https://github.com/Nour963), [kbarlee](https://github.com/kbarlee)
- [AMF] Fixed a crash when a lot of number simultaneous connections occur. ([#886](https://github.com/open5gs/open5gs/issues/886)) -- [dongzx666](https://github.com/dongzx666)
- [MME/AMF] Fixed a bug when S-TMSI does not exist in InitialUEMessage ([#890](https://github.com/open5gs/open5gs/issues/890)) -- [chliny2016](https://github.com/chliny2016) 

#### Enhancement
- [MME/AMF] Added SACK_DELAY_TIME in the AMF/MME configuration files ([#895](https://github.com/open5gs/open5gs/issues/895)) -- [RafalArciszewski](https://github.com/RafalArciszewski) 
- [DB] Updated Python Lib docs and script to migrate DB data to new format ([#889](https://github.com/open5gs/open5gs/pull/889)) -- [nickvsnetworking](https://github.com/nickvsnetworking) 

#### IMPORTANT Using v2.2.x

- **DB Schema Changes:** If you are using an existing subscription DB, you should delete the existing DB. Then you can add a new subscription DB.
{: .blue}
```
$ mongo
> use open5gs
switched to db open5gs
> db.subscribers.drop()
true
```

- **The New WebUI:** You have to log out using the old WebUI backend/frontend. Then, you can log back in again using the new WebUI backend/frontend.
{: .blue}
```
$ git checkout v2.1.7
$ cd webui
$ rm -Rf ./node_modules
$ npm ci --no-optional
$ npm run dev

## You should log out

$ git checkout main
$ cd webui
$ rm -Rf ./node_modules
$ npm ci --no-optional
$ npm run dev

## You can log back in
```

- freeDiameter version has changed from 1.3.2 to 1.5.0. If you want to compile the source code, you need to update meson subprojects as shown below.
{: .blue}

```
$ cd open5gs
$ git pull
$ meson subprojects update
$ cd build
$ ninja
```

Or just use a clean github repository.

```
$ rm -Rf open5gs
$ git clone https://github.com/open5gs/open5gs
$ cd open5gs
$ meson build --prefix=`pwd`/install
$ cd build
$ ninja
```


Download -- [v2.2.4.tar.gz](https://github.com/open5gs/open5gs/archive/v2.2.4.tar.gz)
{: .notice--info}
