---
layout: page
title: Documentation
permalink: /docs/
head_inline: "<style> ul { padding-bottom: 1em; } </style>"
---

- User's Guide
  - [Quickstart](guide/01-quickstart)
  - [Building Open5GS from Sources](guide/02-building-open5gs-from-sources)

- Tutorials
  - [Your First LTE](tutorial/01-your-first-lte)
  - [VoLTE Setup with Kamailio IMS and Open5GS](tutorial/02-VoLTE-setup)
  - [Dockerized VoLTE Setup](tutorial/03-VoLTE-dockerized)

- Troubleshooting
  - [Simple Issues](troubleshoot/01-simple-issues)
  - [Now in Github Issues](troubleshoot/02-now-in-github-issues)

- Platform Specific Notes
  - [Debian/Ubuntu](platform/01-debian-ubuntu)
  - [CentOS](platform/02-centos)
  - [Fedora](platform/03-fedora)
  - [MacOSX(Apple Silicon)](platform/05-macosx-apple-silicon)
  - [MacOSX(Intel)](platform/06-macosx-intel)
  - [FreeBSD](platform/07-freebsd)
  
- Hardware Specific Notes
  - [Tested e/gNodeBs](hardware/01-genodebs)
  
- @infinitydon
  - [Kubernetes Open5GS Deployment](https://dev.to/infinitydon/virtual-4g-simulation-using-kubernetes-and-gns3-3b7k?fbclid=IwAR1p99h13a-mCfejanbBQe0H0-jp5grXkn5mWf1WrTHf47UtegB2-UHGGZQ)

- @nickvsnetworking
  - [My first 5G Core : Open5GS and UERANSIM](http://nickvsnetworking.com/my-first-5g-core-open5gs-and-ueransim/)
  - [Sending SMS in Open5GS LTE Networks using the SGs Interface and OsmoMSC](https://nickvsnetworking.com/sending-sms-in-open5gs-lte-networks-using-the-sgs-interface-and-osmomsc-with-smsos/)
  - [OsmoMSC and Open5GS MME – SGs Interface for CSCF / InterRAT Handover](https://nickvsnetworking.com/osmomsc-and-open5gs-mme-sgs-interface-for-cscf-interran-handover/)
  - [Static IPs for UEs](http://nickvsnetworking.com/open5gs-epc-static-ip-addresses-for-ues-apns-subscribers/)

- @s5uishida
  - [EPC Advanced Example with OpenAirInterface UE/RAN](https://github.com/s5uishida/open5gs_epc_oai_sample_config)
  - [5GC Advanced Example with UERANSIM](https://github.com/s5uishida/open5gs_5gc_ueransim_sample_config)

