/*
 * nwdaf_event.h
 *
 * Possible values are - SLICE_LOAD_LEVEL: Indicates that the event subscribed is load level information of Network Slice instance - NETWORK_PERFORMANCE: Indicates that the event subscribed is network performance information. - NF_LOAD: Indicates that the event subscribed is load level and status of one or several Network Functions. - SERVICE_EXPERIENCE: Indicates that the event subscribed is service experience. - UE_MOBILITY: Indicates that the event subscribed is UE mobility information. - UE_COMMUNICATION: Indicates that the event subscribed is UE communication information. - QOS_SUSTAINABILITY: Indicates that the event subscribed is QoS sustainability. - ABNORMAL_BEHAVIOUR: Indicates that the event subscribed is abnormal behaviour. - USER_DATA_CONGESTION: Indicates that the event subscribed is user data congestion information.
 */

#ifndef _OpenAPI_nwdaf_event_H_
#define _OpenAPI_nwdaf_event_H_

#include <string.h>
#include "../external/cJSON.h"
#include "../include/list.h"
#include "../include/keyValuePair.h"
#include "../include/binary.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct OpenAPI_nwdaf_event_s OpenAPI_nwdaf_event_t;
typedef struct OpenAPI_nwdaf_event_s {
} OpenAPI_nwdaf_event_t;

OpenAPI_nwdaf_event_t *OpenAPI_nwdaf_event_create(
    );
void OpenAPI_nwdaf_event_free(OpenAPI_nwdaf_event_t *nwdaf_event);
OpenAPI_nwdaf_event_t *OpenAPI_nwdaf_event_parseFromJSON(cJSON *nwdaf_eventJSON);
cJSON *OpenAPI_nwdaf_event_convertToJSON(OpenAPI_nwdaf_event_t *nwdaf_event);
OpenAPI_nwdaf_event_t *OpenAPI_nwdaf_event_copy(OpenAPI_nwdaf_event_t *dst, OpenAPI_nwdaf_event_t *src);

#ifdef __cplusplus
}
#endif

#endif /* _OpenAPI_nwdaf_event_H_ */

