---
title: "v2.2.7 - Tested with 500 UEs simultaneous connection"
date: 2021-04-30 14:29:00 +0900
categories:
  - Release
tags:
  - News
  - Release
head_inline: "<style> ul { padding-bottom: 1em; } .blue { color: blue; }</style>"
---

#### Bug Fixes
- [ALL] 500 UEs simultaneous connection test with [UERANSIM](https://github.com/aligungr/UERANSIM) ([#949](https://github.com/open5gs/open5gs/issues/949)) -- [chenhao5651](https://github.com/chenhao5651)
- [MME] Fix the Invalid AMBR Unit ([#967](https://github.com/open5gs/open5gs/issues/967)) -- [matt9j](https://github.com/matt9j)
- [PFCP] Fix the DNS delay during PFCP association ([#891](https://github.com/open5gs/open5gs/issues/891)) -- [DendoD96](https://github.com/DendoD96)
- [Cx] Change the order of IMPUs sent in XML ([#921](https://github.com/open5gs/open5gs/issues/921)) -- [herlesupreeth](https://github.com/herlesupreeth)
- [PFCP] Changed the PFCP RR selection method ([#953](https://github.com/open5gs/open5gs/issues/953)) -- [infinitydon](https://github.com/infinitydon)
- [ALL] Changed the terminate sequence to avoid crash when an invalid IP address is configured ([#938](https://github.com/open5gs/open5gs/issues/938)) -- [myonlystarWang](https://github.com/myonlystarWang)
- [Docker] Update WebUI version to latest ([#945](https://github.com/open5gs/open5gs/issues/945)) -- [rriggio](https://github.com/rriggio)

#### Enhancement
- [MME/AMF] Retransmission on timer expiration for Registration accept / Attach accept
- [MME/AMF] GUTI generation changed ([#910](https://github.com/open5gs/open5gs/issues/910)) -- [chliny2016](https://github.com/chliny2016) 
- [DB] Update open5gs-dbctl ([#940](https://github.com/open5gs/open5gs/pull/940)) -- [Spectranis](https://github.com/Spectranis) 

#### New Features
- [DB] Added DB migration script ([#956](https://github.com/open5gs/open5gs/pull/956), [#968](https://github.com/open5gs/open5gs/pull/968)) -- [matt9j](https://github.com/matt9j) 
- [AMF] Added RANConfigurationUpdate ([#943](https://github.com/open5gs/open5gs/issues/943)) -- [navidsol9](https://github.com/navidsol9) 


#### IMPORTANT Using v2.2.x

- **DB Schema Changes:** If you are using an existing subscription DB, you should delete the existing DB. Then you can add a new subscription DB.
{: .blue}
```
$ mongo
> use open5gs
switched to db open5gs
> db.subscribers.drop()
true
```

- **The New WebUI:** You have to log out using the old WebUI backend/frontend. Then, you can log back in again using the new WebUI backend/frontend.
{: .blue}
```
$ git checkout v2.1.7
$ cd webui
$ rm -Rf ./node_modules
$ npm ci --no-optional
$ npm run dev

## You should log out

$ git checkout main
$ cd webui
$ rm -Rf ./node_modules
$ npm ci --no-optional
$ npm run dev

## You can log back in
```

- freeDiameter version has changed from 1.3.2 to 1.5.0. If you want to compile the source code, you need to update meson subprojects as shown below.
{: .blue}

```
$ cd open5gs
$ git pull
$ meson subprojects update
$ cd build
$ ninja
```

Or just use a clean github repository.

```
$ rm -Rf open5gs
$ git clone https://github.com/open5gs/open5gs
$ cd open5gs
$ meson build --prefix=`pwd`/install
$ cd build
$ ninja
```


Download -- [v2.2.7.tar.gz](https://github.com/open5gs/open5gs/archive/v2.2.7.tar.gz)
{: .notice--info}
