
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "gbr_qos_flow_information.h"

OpenAPI_gbr_qos_flow_information_t *OpenAPI_gbr_qos_flow_information_create(
    char *max_fbr_dl,
    char *max_fbr_ul,
    char *gua_fbr_dl,
    char *gua_fbr_ul,
    OpenAPI_notification_control_t *notif_control,
    int max_packet_loss_rate_dl,
    int max_packet_loss_rate_ul
    )
{
    OpenAPI_gbr_qos_flow_information_t *gbr_qos_flow_information_local_var = OpenAPI_malloc(sizeof(OpenAPI_gbr_qos_flow_information_t));
    if (!gbr_qos_flow_information_local_var) {
        return NULL;
    }
    gbr_qos_flow_information_local_var->max_fbr_dl = max_fbr_dl;
    gbr_qos_flow_information_local_var->max_fbr_ul = max_fbr_ul;
    gbr_qos_flow_information_local_var->gua_fbr_dl = gua_fbr_dl;
    gbr_qos_flow_information_local_var->gua_fbr_ul = gua_fbr_ul;
    gbr_qos_flow_information_local_var->notif_control = notif_control;
    gbr_qos_flow_information_local_var->max_packet_loss_rate_dl = max_packet_loss_rate_dl;
    gbr_qos_flow_information_local_var->max_packet_loss_rate_ul = max_packet_loss_rate_ul;

    return gbr_qos_flow_information_local_var;
}

void OpenAPI_gbr_qos_flow_information_free(OpenAPI_gbr_qos_flow_information_t *gbr_qos_flow_information)
{
    if (NULL == gbr_qos_flow_information) {
        return;
    }
    OpenAPI_lnode_t *node;
    ogs_free(gbr_qos_flow_information->max_fbr_dl);
    ogs_free(gbr_qos_flow_information->max_fbr_ul);
    ogs_free(gbr_qos_flow_information->gua_fbr_dl);
    ogs_free(gbr_qos_flow_information->gua_fbr_ul);
    OpenAPI_notification_control_free(gbr_qos_flow_information->notif_control);
    ogs_free(gbr_qos_flow_information);
}

cJSON *OpenAPI_gbr_qos_flow_information_convertToJSON(OpenAPI_gbr_qos_flow_information_t *gbr_qos_flow_information)
{
    cJSON *item = NULL;

    if (gbr_qos_flow_information == NULL) {
        ogs_error("OpenAPI_gbr_qos_flow_information_convertToJSON() failed [GbrQosFlowInformation]");
        return NULL;
    }

    item = cJSON_CreateObject();
    if (!gbr_qos_flow_information->max_fbr_dl) {
        ogs_error("OpenAPI_gbr_qos_flow_information_convertToJSON() failed [max_fbr_dl]");
        goto end;
    }
    if (cJSON_AddStringToObject(item, "maxFbrDl", gbr_qos_flow_information->max_fbr_dl) == NULL) {
        ogs_error("OpenAPI_gbr_qos_flow_information_convertToJSON() failed [max_fbr_dl]");
        goto end;
    }

    if (!gbr_qos_flow_information->max_fbr_ul) {
        ogs_error("OpenAPI_gbr_qos_flow_information_convertToJSON() failed [max_fbr_ul]");
        goto end;
    }
    if (cJSON_AddStringToObject(item, "maxFbrUl", gbr_qos_flow_information->max_fbr_ul) == NULL) {
        ogs_error("OpenAPI_gbr_qos_flow_information_convertToJSON() failed [max_fbr_ul]");
        goto end;
    }

    if (!gbr_qos_flow_information->gua_fbr_dl) {
        ogs_error("OpenAPI_gbr_qos_flow_information_convertToJSON() failed [gua_fbr_dl]");
        goto end;
    }
    if (cJSON_AddStringToObject(item, "guaFbrDl", gbr_qos_flow_information->gua_fbr_dl) == NULL) {
        ogs_error("OpenAPI_gbr_qos_flow_information_convertToJSON() failed [gua_fbr_dl]");
        goto end;
    }

    if (!gbr_qos_flow_information->gua_fbr_ul) {
        ogs_error("OpenAPI_gbr_qos_flow_information_convertToJSON() failed [gua_fbr_ul]");
        goto end;
    }
    if (cJSON_AddStringToObject(item, "guaFbrUl", gbr_qos_flow_information->gua_fbr_ul) == NULL) {
        ogs_error("OpenAPI_gbr_qos_flow_information_convertToJSON() failed [gua_fbr_ul]");
        goto end;
    }

    if (gbr_qos_flow_information->notif_control) {
        cJSON *notif_control_local_JSON = OpenAPI_notification_control_convertToJSON(gbr_qos_flow_information->notif_control);
        if (notif_control_local_JSON == NULL) {
            ogs_error("OpenAPI_gbr_qos_flow_information_convertToJSON() failed [notif_control]");
            goto end;
        }
        cJSON_AddItemToObject(item, "notifControl", notif_control_local_JSON);
        if (item->child == NULL) {
            ogs_error("OpenAPI_gbr_qos_flow_information_convertToJSON() failed [notif_control]");
            goto end;
        }
    }

    if (gbr_qos_flow_information->max_packet_loss_rate_dl) {
        if (cJSON_AddNumberToObject(item, "maxPacketLossRateDl", gbr_qos_flow_information->max_packet_loss_rate_dl) == NULL) {
            ogs_error("OpenAPI_gbr_qos_flow_information_convertToJSON() failed [max_packet_loss_rate_dl]");
            goto end;
        }
    }

    if (gbr_qos_flow_information->max_packet_loss_rate_ul) {
        if (cJSON_AddNumberToObject(item, "maxPacketLossRateUl", gbr_qos_flow_information->max_packet_loss_rate_ul) == NULL) {
            ogs_error("OpenAPI_gbr_qos_flow_information_convertToJSON() failed [max_packet_loss_rate_ul]");
            goto end;
        }
    }

end:
    return item;
}

OpenAPI_gbr_qos_flow_information_t *OpenAPI_gbr_qos_flow_information_parseFromJSON(cJSON *gbr_qos_flow_informationJSON)
{
    OpenAPI_gbr_qos_flow_information_t *gbr_qos_flow_information_local_var = NULL;
    cJSON *max_fbr_dl = cJSON_GetObjectItemCaseSensitive(gbr_qos_flow_informationJSON, "maxFbrDl");
    if (!max_fbr_dl) {
        ogs_error("OpenAPI_gbr_qos_flow_information_parseFromJSON() failed [max_fbr_dl]");
        goto end;
    }


    if (!cJSON_IsString(max_fbr_dl)) {
        ogs_error("OpenAPI_gbr_qos_flow_information_parseFromJSON() failed [max_fbr_dl]");
        goto end;
    }

    cJSON *max_fbr_ul = cJSON_GetObjectItemCaseSensitive(gbr_qos_flow_informationJSON, "maxFbrUl");
    if (!max_fbr_ul) {
        ogs_error("OpenAPI_gbr_qos_flow_information_parseFromJSON() failed [max_fbr_ul]");
        goto end;
    }


    if (!cJSON_IsString(max_fbr_ul)) {
        ogs_error("OpenAPI_gbr_qos_flow_information_parseFromJSON() failed [max_fbr_ul]");
        goto end;
    }

    cJSON *gua_fbr_dl = cJSON_GetObjectItemCaseSensitive(gbr_qos_flow_informationJSON, "guaFbrDl");
    if (!gua_fbr_dl) {
        ogs_error("OpenAPI_gbr_qos_flow_information_parseFromJSON() failed [gua_fbr_dl]");
        goto end;
    }


    if (!cJSON_IsString(gua_fbr_dl)) {
        ogs_error("OpenAPI_gbr_qos_flow_information_parseFromJSON() failed [gua_fbr_dl]");
        goto end;
    }

    cJSON *gua_fbr_ul = cJSON_GetObjectItemCaseSensitive(gbr_qos_flow_informationJSON, "guaFbrUl");
    if (!gua_fbr_ul) {
        ogs_error("OpenAPI_gbr_qos_flow_information_parseFromJSON() failed [gua_fbr_ul]");
        goto end;
    }


    if (!cJSON_IsString(gua_fbr_ul)) {
        ogs_error("OpenAPI_gbr_qos_flow_information_parseFromJSON() failed [gua_fbr_ul]");
        goto end;
    }

    cJSON *notif_control = cJSON_GetObjectItemCaseSensitive(gbr_qos_flow_informationJSON, "notifControl");

    OpenAPI_notification_control_t *notif_control_local_nonprim = NULL;
    if (notif_control) {
        notif_control_local_nonprim = OpenAPI_notification_control_parseFromJSON(notif_control);
    }

    cJSON *max_packet_loss_rate_dl = cJSON_GetObjectItemCaseSensitive(gbr_qos_flow_informationJSON, "maxPacketLossRateDl");

    if (max_packet_loss_rate_dl) {
        if (!cJSON_IsNumber(max_packet_loss_rate_dl)) {
            ogs_error("OpenAPI_gbr_qos_flow_information_parseFromJSON() failed [max_packet_loss_rate_dl]");
            goto end;
        }
    }

    cJSON *max_packet_loss_rate_ul = cJSON_GetObjectItemCaseSensitive(gbr_qos_flow_informationJSON, "maxPacketLossRateUl");

    if (max_packet_loss_rate_ul) {
        if (!cJSON_IsNumber(max_packet_loss_rate_ul)) {
            ogs_error("OpenAPI_gbr_qos_flow_information_parseFromJSON() failed [max_packet_loss_rate_ul]");
            goto end;
        }
    }

    gbr_qos_flow_information_local_var = OpenAPI_gbr_qos_flow_information_create (
        ogs_strdup(max_fbr_dl->valuestring),
        ogs_strdup(max_fbr_ul->valuestring),
        ogs_strdup(gua_fbr_dl->valuestring),
        ogs_strdup(gua_fbr_ul->valuestring),
        notif_control ? notif_control_local_nonprim : NULL,
        max_packet_loss_rate_dl ? max_packet_loss_rate_dl->valuedouble : 0,
        max_packet_loss_rate_ul ? max_packet_loss_rate_ul->valuedouble : 0
        );

    return gbr_qos_flow_information_local_var;
end:
    return NULL;
}

OpenAPI_gbr_qos_flow_information_t *OpenAPI_gbr_qos_flow_information_copy(OpenAPI_gbr_qos_flow_information_t *dst, OpenAPI_gbr_qos_flow_information_t *src)
{
    cJSON *item = NULL;
    char *content = NULL;

    ogs_assert(src);
    item = OpenAPI_gbr_qos_flow_information_convertToJSON(src);
    if (!item) {
        ogs_error("OpenAPI_gbr_qos_flow_information_convertToJSON() failed");
        return NULL;
    }

    content = cJSON_Print(item);
    cJSON_Delete(item);

    if (!content) {
        ogs_error("cJSON_Print() failed");
        return NULL;
    }

    item = cJSON_Parse(content);
    ogs_free(content);
    if (!item) {
        ogs_error("cJSON_Parse() failed");
        return NULL;
    }

    OpenAPI_gbr_qos_flow_information_free(dst);
    dst = OpenAPI_gbr_qos_flow_information_parseFromJSON(item);
    cJSON_Delete(item);

    return dst;
}

