---
title: "v2.2.8 - Security Protection"
date: 2021-05-09 11:27:00 +0900
categories:
  - Release
tags:
  - News
  - Release
head_inline: "<style> ul { padding-bottom: 1em; } .blue { color: blue; }</style>"
---

#### Bug Fixes
- [AMF] Distinguish between Cleartext and Non-cleartext IEs ([#958](https://github.com/open5gs/open5gs/issues/958), [UERANSIM#316](https://github.com/aligungr/UERANSIM/issues/316)) -- [p1-bmu](https://github.com/p1-bmu), [aligungr](https://github.com/aligungr)
- [AMF] Fix SBI convert error for ng_ap_cause ([UERANSIM#316](https://github.com/aligungr/UERANSIM/issues/316)) -- [aligungr](https://github.com/aligungr)
- [AMF] Allocate ngKSI other than the value already used ([UERANSIM#316](https://github.com/aligungr/UERANSIM/issues/316)) -- [aligungr](https://github.com/aligungr)
- [AMF] fix the UE-AMBR usage in NGAP message ([#979](https://github.com/open5gs/open5gs/issues/979)) -- [mcatalancid](https://github.com/mcatalancid)
- [SMF/UPF] Add assertion for getprotobyname() error when decoding IPFilterRule ([#977](https://github.com/open5gs/open5gs/issues/977)) -- [herlesupreeth](https://github.com/herlesupreeth)
- [MME/SGW-C] Fix the bug of encoding GTPv2 PLMN-ID ([#969](https://github.com/open5gs/open5gs/issues/969)) -- [gusbourg](https://github.com/gusbourg)
- [MME] Fix the bug of encoding NAS AMBR ([#967](https://github.com/open5gs/open5gs/issues/967)) -- [matt9j](https://github.com/matt9j)
- [AMF] Protetion of malformed NGAP message ([#960](https://github.com/open5gs/open5gs/issues/960)) -- [p1-bmu](https://github.com/p1-bmu)
- [AMF] Protetion of malformed NAS message ([#959](https://github.com/open5gs/open5gs/issues/959)) -- [p1-bmu](https://github.com/p1-bmu)
- [WebUI] fix the security flaw in default admin account ([#764](https://github.com/open5gs/open5gs/issues/764)) -- [martinzhou2015](https://github.com/martinzhou2015)

#### New Features
- [OS] Support Alpine ([#957](https://github.com/open5gs/open5gs/pull/957), [#968](https://github.com/open5gs/open5gs/pull/968)) -- [venkatpilla](https://github.com/venkatpilla)

#### IMPORTANT Using v2.2.x

- **DB Schema Changes:** If you are using an existing subscription DB, you should delete the existing DB. Then you can add a new subscription DB.
{: .blue}
```
$ mongo
> use open5gs
switched to db open5gs
> db.subscribers.drop()
true
```

- **The New WebUI:** You have to log out using the old WebUI backend/frontend. Then, you can log back in again using the new WebUI backend/frontend.
{: .blue}
```
$ git checkout v2.1.7
$ cd webui
$ rm -Rf ./node_modules
$ npm ci --no-optional
$ npm run dev

## You should log out

$ git checkout main
$ cd webui
$ rm -Rf ./node_modules
$ npm ci --no-optional
$ npm run dev

## You can log back in
```

- freeDiameter version has changed from 1.3.2 to 1.5.0. If you want to compile the source code, you need to update meson subprojects as shown below.
{: .blue}

```
$ cd open5gs
$ git pull
$ meson subprojects update
$ cd build
$ ninja
```

Or just use a clean github repository.

```
$ rm -Rf open5gs
$ git clone https://github.com/open5gs/open5gs
$ cd open5gs
$ meson build --prefix=`pwd`/install
$ cd build
$ ninja
```


Download -- [v2.2.8.tar.gz](https://github.com/open5gs/open5gs/archive/v2.2.8.tar.gz)
{: .notice--info}
