---
title: "v1.2.2 - Created by Working Together"
date: 2020-03-25 15:05:00 -0600
categories:
  - Release
tags:
  - News
  - Release
head_inline: "<style> ul { padding-bottom: 1em; } </style>"
---

#### Document
- Kubernetes Open5GS Development ([#375](https://github.com/open5gs/open5gs/issus/375)) -- [infinitydon](https://github.com/infinitydon)

#### UE address subnet
- Change default UE address subnet from 45.45.0.1/16 to 10.45.0.1/16 ([#369](https://github.com/open5gs/open5gs/pull/369)) -- [spencersevilla](https://github.com/spencersevilla)

#### New Features

###### Provide SGW GTP(S1) address to be advertised inside S1AP messages ([#367](https://github.com/open5gs/open5gs/pull/367)) -- [herlesupreeth](https://github.com/herlesupreeth)

This feature is useful in scenarios where SGW is run inside a container or openstack vm i.e. behind 1-to-1 mapping NAT. In docker/openstack environment, we often have 1-to-1 mapped NAT IP address in order for eNB to reach SGW. But, this 1-to-1 mapping NAT IP address is not seen on SGW host and hence non UDP socket bindable. Since SGW can only bind to IP address visible in it's host (usually a private IP beind a NAT), it advertises the same to UE in S1AP message resulting in eNB not able to reach SGW on Uplink. This commit solves this issue by providing a means to advertise a different IP address than the one SGW UDP socket is bound to.

Example of sgw.yaml to use this feature:

```
logger:
    file: /var/log/open5gs/sgw.log
    level: debug

parameter:
    no_ipv6: true

sgw:
    gtpc:
      addr: 127.0.0.2
    gtpu:
      dev: ens3
      advertise_addr:
        - 172.24.15.30
        - fe80::f816:3eff:fe15:fe34

    OR

    gtpu:
      addr: 10.4.128.21
      advertise_name: sgw1.epc.mnc001.mcc001.3gppnetwork.org

    OR

    gtpu:
      dev: ens3
      advertise_name: sgw1.epc.mnc001.mcc001.3gppnetwork.org
```

###### Provide MTU size to be advertised in PCO options ([#376](https://github.com/open5gs/open5gs/pull/376)) -- [herlesupreeth](https://github.com/herlesupreeth)

This feature can be used for provisioning a limit on the size of the packets
sent by the MS to avoid packet fragmentation in the backbone network between
the MS and the GGSN/PGW and/or across the (S)Gi reference point) when some
of the backbone links does not support packets larger then 1500 octets
(ETSI TS 123 060 V15.5.0 Annex C)

Example of pgw.yaml to use this feature:

```
logger:
    file: /var/log/open5gs/pgw.log

parameter:

pgw:
    freeDiameter: /etc/open5gs/freeDiameter/pgw.conf
    gtpc:
      - addr: 127.0.0.3
      - addr: ::1
    gtpu:
      - addr: 127.0.0.3
      - addr: ::1
    ue_pool:
      - addr: 10.45.0.1/16
      - addr: cafe::1/64
    dns:
      - 8.8.8.8
      - 8.8.4.4
      - 2001:4860:4860::8888
      - 2001:4860:4860::8844
    mtu: 1400
```


#### Enhancement
- Add GTPv2 Echo Request/Response message ([#378](https://github.com/open5gs/open5gs/issues/378)) -- [BGOtura](https://github.com/BGOtura)
- Add 'open5gs-dbctl' script in debain package ([#388](https://github.com/open5gs/open5gs/pull/388)) -- [spencersevilla](https://github.com/spencersevilla)
- Add editing subscribers with PythonAPI interface -- [nickvsnetworking](https://github.com/nickvsnetworking)


#### Bug Fixed
- Check Session-Context before Sending InitialContextSetupRequest ([#384](https://github.com/open5gs/open5gs/issues/384)) -- [EugeneBogush](https://github.com/EugeneBogush)
- Fix for the systemd reload ([#393](https://github.com/open5gs/open5gs/pull/393)) -- [EugeneBogush](https://github.com/EugeneBogush)
- Fix the systemd unit file for Debian ([#377](https://github.com/open5gs/open5gs/pull/377)) -- [rafael2k](https://github.com/rafael2k)
- Add build dependancy to 'git' ([#373](https://github.com/open5gs/open5gs/pull/373)) -- [laf0rge](https://github.com/laf0rge)
- Add PGW dependancy to 'systemd-networkd' -- [spencersevilla](https://github.com/spencersevilla)
- Fix the WebUI installation script for Debian


Download -- [v1.2.2.tar.gz](https://github.com/open5gs/open5gs/archive/v1.2.2.tar.gz)
{: .notice--info}
