---
title: "v2.5.0 - SCP for Indirect Communication"
date: 2022-10-25 22:54:00 +0900
categories:
  - Release
tags:
  - News
  - Release
head_inline: "<style> ul { padding-bottom: 1em; } .blue { color: blue; }</style>"
---

#### New Feature

SCP(Service Communication Proxy) is added to support Indirect Communication based on TS29.500. The default Open5GS configuration is provided as an indirect communication using SCP.

- [amf.yaml] If NFs are configured to use Delegated Discovery through the SCP, you do not need to set up NRF.

```
amf:
    sbi:
      - addr: 127.0.0.5
        port: 7777

scp:
    sbi:
      - addr: 127.0.1.10
        port: 7777

#nrf:
#    sbi:
#      - addr:
#          - 127.0.0.10
#          - ::1
#        port: 7777
```

- [scp.yaml] NRF is needed for Delegated Discovery in SCP configuration.

```
scp:
    sbi:
      - addr: 127.0.1.10
        port: 7777

#
# next_scp:
#    sbi:
#      addr: 127.0.1.11
#      port: 7777
#

nrf:
    sbi:
      - addr:
          - 127.0.0.10
          - ::1
        port: 7777
```

- [nrf.yaml] If there is an SCP in the NRF configuration, a notification(nnrf-nfm/nf-status-notify) is sent through an indirect communication.

```
nrf:
    sbi:
      addr:
        - 127.0.0.10
        - ::1
      port: 7777

scp:
    sbi:
      - addr: 127.0.1.10
        port: 7777
```


#### Enhancements
- [WebUI/DB] Fixed the WebUI to Support MongoDB 6.0( ([#1824](https://github.com/open5gs/open5gs/issues/1824)) -- [bmeglicit](https://github.com/bmeglicit)
- [DBI] Disable Changes Streams with mongo Version ([#1833](https://github.com/open5gs/open5gs/pull/1833)) -- [jmasterfunk84](https://github.com/jmasterfunk84)
- [SBI] Added 3gpp-Sbi-Sender-Timestamp and 3gpp-Sbi-Max-Rsp-Time -- [7c8722d](https://github.com/open5gs/open5gs/commit/7c8722d9d4d2db13d889be1e5e37bc062f069396)
- [MME] Cancel Location while Idle ([#1797](https://github.com/open5gs/open5gs/pull/1797)) -- [jmasterfunk84](https://github.com/jmasterfunk84)
- [MME] Support for Insert Subscriber Data ([#1794](https://github.com/open5gs/open5gs/pull/1794)) -- [jmasterfunk84](https://github.com/jmasterfunk84)

#### Bug Fixes
- [SGW-C] Fixed the bug of SGW-C session deletion ([#1825](https://github.com/open5gs/open5gs/pull/1825)) -- [dai9000](https://github.com/dai9000), [cmmacneill53](https://github.com/cmmacneill53)
- [AMF] Reject registration requests when pool for UE context is empty ([#1828](https://github.com/open5gs/open5gs/pull/1828)) -- [bmeglicit](https://github.com/bmeglicit)
- [AMF] Increase size of TMSI pool ([#1827](https://github.com/open5gs/open5gs/pull/1827)) -- [bmeglicit](https://github.com/bmeglicit)
- [AMF/UDM] Added support to subscribe to SDM changes ([#1820](https://github.com/open5gs/open5gs/pull/1820)) -- [bmeglicit](https://github.com/bmeglicit)
- [PFCP] Do not check qos_flow in PFCP Report message ([#1819](https://github.com/open5gs/open5gs/pull/1819)) -- [ssafaorhan](https://github.com/ssafaorhan)
- [PFCP] Fixed invalid message of Dropped DL Traffic threshold ([#1817](https://github.com/open5gs/open5gs/pull/1817)) -- [ssafaorhan](https://github.com/ssafaorhan)

Download -- [v2.5.0.tar.gz](https://github.com/open5gs/open5gs/archive/v2.5.0.tar.gz)
{: .notice--info}
