/*
 * subscription_data_sets.h
 *
 * 
 */

#ifndef _OpenAPI_subscription_data_sets_H_
#define _OpenAPI_subscription_data_sets_H_

#include <string.h>
#include "../external/cJSON.h"
#include "../include/list.h"
#include "../include/keyValuePair.h"
#include "../include/binary.h"
#include "access_and_mobility_subscription_data.h"
#include "lcs_broadcast_assistance_types_data.h"
#include "lcs_mo_data.h"
#include "lcs_privacy_data.h"
#include "session_management_subscription_data.h"
#include "smf_selection_subscription_data.h"
#include "sms_management_subscription_data.h"
#include "sms_subscription_data.h"
#include "trace_data_1.h"
#include "ue_context_in_amf_data.h"
#include "ue_context_in_smf_data.h"
#include "ue_context_in_smsf_data.h"
#include "v2x_subscription_data.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct OpenAPI_subscription_data_sets_s OpenAPI_subscription_data_sets_t;
typedef struct OpenAPI_subscription_data_sets_s {
    struct OpenAPI_access_and_mobility_subscription_data_s *am_data;
    struct OpenAPI_smf_selection_subscription_data_s *smf_sel_data;
    struct OpenAPI_ue_context_in_amf_data_s *uec_amf_data;
    struct OpenAPI_ue_context_in_smf_data_s *uec_smf_data;
    struct OpenAPI_ue_context_in_smsf_data_s *uec_smsf_data;
    struct OpenAPI_sms_subscription_data_s *sms_subs_data;
    OpenAPI_list_t *sm_data;
    struct OpenAPI_trace_data_1_s *trace_data;
    struct OpenAPI_sms_management_subscription_data_s *sms_mng_data;
    struct OpenAPI_lcs_privacy_data_s *lcs_privacy_data;
    struct OpenAPI_lcs_mo_data_s *lcs_mo_data;
    struct OpenAPI_v2x_subscription_data_s *v2x_data;
    struct OpenAPI_lcs_broadcast_assistance_types_data_s *lcs_broadcast_assistance_types_data;
} OpenAPI_subscription_data_sets_t;

OpenAPI_subscription_data_sets_t *OpenAPI_subscription_data_sets_create(
    OpenAPI_access_and_mobility_subscription_data_t *am_data,
    OpenAPI_smf_selection_subscription_data_t *smf_sel_data,
    OpenAPI_ue_context_in_amf_data_t *uec_amf_data,
    OpenAPI_ue_context_in_smf_data_t *uec_smf_data,
    OpenAPI_ue_context_in_smsf_data_t *uec_smsf_data,
    OpenAPI_sms_subscription_data_t *sms_subs_data,
    OpenAPI_list_t *sm_data,
    OpenAPI_trace_data_1_t *trace_data,
    OpenAPI_sms_management_subscription_data_t *sms_mng_data,
    OpenAPI_lcs_privacy_data_t *lcs_privacy_data,
    OpenAPI_lcs_mo_data_t *lcs_mo_data,
    OpenAPI_v2x_subscription_data_t *v2x_data,
    OpenAPI_lcs_broadcast_assistance_types_data_t *lcs_broadcast_assistance_types_data
);
void OpenAPI_subscription_data_sets_free(OpenAPI_subscription_data_sets_t *subscription_data_sets);
OpenAPI_subscription_data_sets_t *OpenAPI_subscription_data_sets_parseFromJSON(cJSON *subscription_data_setsJSON);
cJSON *OpenAPI_subscription_data_sets_convertToJSON(OpenAPI_subscription_data_sets_t *subscription_data_sets);
OpenAPI_subscription_data_sets_t *OpenAPI_subscription_data_sets_copy(OpenAPI_subscription_data_sets_t *dst, OpenAPI_subscription_data_sets_t *src);

#ifdef __cplusplus
}
#endif

#endif /* _OpenAPI_subscription_data_sets_H_ */

