---
title: "v2.2.9 - Ubuntu 21.04(hirsute) Release"
date: 2021-05-19 14:13:00 +0900
categories:
  - Release
tags:
  - News
  - Release
head_inline: "<style> ul { padding-bottom: 1em; } .blue { color: blue; }</style>"
---

#### Bug Fixes
- [AMF] Fix the bug related to Cleartext and Non-cleartext IEs 
([#1006](https://github.com/open5gs/open5gs/issues/1006), [#958](https://github.com/open5gs/open5gs/issues/958), [UERANSIM#316](https://github.com/aligungr/UERANSIM/issues/316)) -- [ramonss](https://github.com/ramonss), [p1-bmu](https://github.com/p1-bmu), [aligungr](https://github.com/aligungr)
- [AMF] Add protection code for message(asn1c, nas, gtp, pfcp) encoding ([#991](https://github.com/open5gs/open5gs/issues/991)) -- [shuimoshusheng](https://github.com/shuimoshusheng)
- [MME] Packet filter (flow) precedence should be assigned within the session, not bearer. ([#1001](https://github.com/open5gs/open5gs/pull/1001)) -- [herlesupreeth](https://github.com/herlesupreeth)
- [MME/SGW-C/SGW-U/SMF/UPF] Force shutdown when UDP port duplicated with other process ([#986](https://github.com/open5gs/open5gs/issues/986), [#992](https://github.com/open5gs/open5gs/issues/992)) -- [ybouhamza](https://github.com/ybouhamza), [polhenarejos](https://github.com/polhenarejos)
- [AMF] Fix the error of decoding Extended-RANNodeName ([#994](https://github.com/open5gs/open5gs/issues/994)) -- [fefer](https://github.com/fefer)
- [AMF] Add more buffer for 5GMM capability ([#959](https://github.com/open5gs/open5gs/issues/959)) -- [p1-bmu](https://github.com/p1-bmu)

#### IMPORTANT Using v2.2.x

- **DB Schema Changes:** If you are using an existing subscription DB, you should delete the existing DB. Then you can add a new subscription DB.
{: .blue}
```
$ mongo
> use open5gs
switched to db open5gs
> db.subscribers.drop()
true
```

- **The New WebUI:** You have to log out using the old WebUI backend/frontend. Then, you can log back in again using the new WebUI backend/frontend.
{: .blue}
```
$ git checkout v2.1.7
$ cd webui
$ rm -Rf ./node_modules
$ npm ci
$ npm run dev

## You should log out

$ git checkout main
$ cd webui
$ rm -Rf ./node_modules
$ npm ci
$ npm run dev

## You can log back in
```

- freeDiameter version has changed from 1.3.2 to 1.5.0. If you want to compile the source code, you need to update meson subprojects as shown below.
{: .blue}

```
$ cd open5gs
$ git pull
$ meson subprojects update
$ cd build
$ ninja
```

Or just use a clean github repository.

```
$ rm -Rf open5gs
$ git clone https://github.com/open5gs/open5gs
$ cd open5gs
$ meson build --prefix=`pwd`/install
$ cd build
$ ninja
```


Download -- [v2.2.9.tar.gz](https://github.com/open5gs/open5gs/archive/v2.2.9.tar.gz)
{: .notice--info}
