/*
 * OsmocomBB <-> SDR connection bridge
 * TDMA scheduler: channel combinations, burst mapping
 *
 * (C) 2013 by Andreas Eversberg <jolly@eversberg.eu>
 * (C) 2015 by Alexander Chemeris <Alexander.Chemeris@fairwaves.co>
 * (C) 2015 by Harald Welte <laforge@gnumonks.org>
 *
 * All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <osmocom/gsm/gsm_utils.h>

#include <osmocom/bb/l1sched/l1sched.h>
#include <osmocom/bb/l1sched/logging.h>

/* Non-combined CCCH */
static const struct l1sched_tdma_frame frame_bcch[51] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_FCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_BCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_BCCH,		1,	L1SCHED_RACH,		0 },
	{ L1SCHED_BCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_BCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		1,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_FCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		1,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		1,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_FCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		1,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		1,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_FCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		1,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		1,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_FCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		1,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		1,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_IDLE,		0,	L1SCHED_RACH,		0 },
};

/* Combined CCCH+SDCCH4 */
static const struct l1sched_tdma_frame frame_bcch_sdcch4[102] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_FCCH,		0,	L1SCHED_SDCCH4_3,	0 },
	{ L1SCHED_SCH,		0,	L1SCHED_SDCCH4_3,	1 },
	{ L1SCHED_BCCH,		0,	L1SCHED_SDCCH4_3,	2 },
	{ L1SCHED_BCCH,		1,	L1SCHED_SDCCH4_3,	3 },
	{ L1SCHED_BCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_BCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		0,	L1SCHED_SACCH4_2,	0 },
	{ L1SCHED_CCCH,		1,	L1SCHED_SACCH4_2,	1 },
	{ L1SCHED_CCCH,		2,	L1SCHED_SACCH4_2,	2 },
	{ L1SCHED_CCCH,		3,	L1SCHED_SACCH4_2,	3 },
	{ L1SCHED_FCCH,		0,	L1SCHED_SACCH4_3,	0 },
	{ L1SCHED_SCH,		0,	L1SCHED_SACCH4_3,	1 },
	{ L1SCHED_CCCH,		0,	L1SCHED_SACCH4_3,	2 },
	{ L1SCHED_CCCH,		1,	L1SCHED_SACCH4_3,	3 },
	{ L1SCHED_CCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		1,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_FCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_0,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_0,	1,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_0,	2,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_0,	3,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_1,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_1,	1,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_1,	2,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_1,	3,	L1SCHED_RACH,		0 },
	{ L1SCHED_FCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_2,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_2,	1,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_2,	2,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_2,	3,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_3,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_3,	1,	L1SCHED_SDCCH4_0,	0 },
	{ L1SCHED_SDCCH4_3,	2,	L1SCHED_SDCCH4_0,	1 },
	{ L1SCHED_SDCCH4_3,	3,	L1SCHED_SDCCH4_0,	2 },
	{ L1SCHED_FCCH,		0,	L1SCHED_SDCCH4_0,	3 },
	{ L1SCHED_SCH,		0,	L1SCHED_SDCCH4_1,	0 },
	{ L1SCHED_SACCH4_0,	0,	L1SCHED_SDCCH4_1,	1 },
	{ L1SCHED_SACCH4_0,	1,	L1SCHED_SDCCH4_1,	2 },
	{ L1SCHED_SACCH4_0,	2,	L1SCHED_SDCCH4_1,	3 },
	{ L1SCHED_SACCH4_0,	3,	L1SCHED_RACH,		0 },
	{ L1SCHED_SACCH4_1,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SACCH4_1,	1,	L1SCHED_SDCCH4_2,	0 },
	{ L1SCHED_SACCH4_1,	2,	L1SCHED_SDCCH4_2,	1 },
	{ L1SCHED_SACCH4_1,	3,	L1SCHED_SDCCH4_2,	2 },
	{ L1SCHED_IDLE,		0,	L1SCHED_SDCCH4_2,	3 },

	{ L1SCHED_FCCH,		0,	L1SCHED_SDCCH4_3,	0 },
	{ L1SCHED_SCH,		0,	L1SCHED_SDCCH4_3,	1 },
	{ L1SCHED_BCCH,		0,	L1SCHED_SDCCH4_3,	2 },
	{ L1SCHED_BCCH,		1,	L1SCHED_SDCCH4_3,	3 },
	{ L1SCHED_BCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_BCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		0,	L1SCHED_SACCH4_0,	0 },
	{ L1SCHED_CCCH,		1,	L1SCHED_SACCH4_0,	1 },
	{ L1SCHED_CCCH,		2,	L1SCHED_SACCH4_0,	2 },
	{ L1SCHED_CCCH,		3,	L1SCHED_SACCH4_0,	3 },
	{ L1SCHED_FCCH,		0,	L1SCHED_SACCH4_1,	0 },
	{ L1SCHED_SCH,		0,	L1SCHED_SACCH4_1,	1 },
	{ L1SCHED_CCCH,		0,	L1SCHED_SACCH4_1,	2 },
	{ L1SCHED_CCCH,		1,	L1SCHED_SACCH4_1,	3 },
	{ L1SCHED_CCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		1,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_FCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_0,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_0,	1,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_0,	2,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_0,	3,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_1,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_1,	1,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_1,	2,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_1,	3,	L1SCHED_RACH,		0 },
	{ L1SCHED_FCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_2,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_2,	1,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_2,	2,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_2,	3,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_3,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_3,	1,	L1SCHED_SDCCH4_0,	0 },
	{ L1SCHED_SDCCH4_3,	2,	L1SCHED_SDCCH4_0,	1 },
	{ L1SCHED_SDCCH4_3,	3,	L1SCHED_SDCCH4_0,	2 },
	{ L1SCHED_FCCH,		0,	L1SCHED_SDCCH4_0,	3 },
	{ L1SCHED_SCH,		0,	L1SCHED_SDCCH4_1,	0 },
	{ L1SCHED_SACCH4_2,	0,	L1SCHED_SDCCH4_1,	1 },
	{ L1SCHED_SACCH4_2,	1,	L1SCHED_SDCCH4_1,	2 },
	{ L1SCHED_SACCH4_2,	2,	L1SCHED_SDCCH4_1,	3 },
	{ L1SCHED_SACCH4_2,	3,	L1SCHED_RACH,		0 },
	{ L1SCHED_SACCH4_3,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SACCH4_3,	1,	L1SCHED_SDCCH4_2,	0 },
	{ L1SCHED_SACCH4_3,	2,	L1SCHED_SDCCH4_2,	1 },
	{ L1SCHED_SACCH4_3,	3,	L1SCHED_SDCCH4_2,	2 },
	{ L1SCHED_IDLE,		0,	L1SCHED_SDCCH4_2,	3 },
};

static const struct l1sched_tdma_frame frame_bcch_sdcch4_cbch[102] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_FCCH,		0,	L1SCHED_SDCCH4_3,	0 },
	{ L1SCHED_SCH,		0,	L1SCHED_SDCCH4_3,	1 },
	{ L1SCHED_BCCH,		0,	L1SCHED_SDCCH4_3,	2 },
	{ L1SCHED_BCCH,		1,	L1SCHED_SDCCH4_3,	3 },
	{ L1SCHED_BCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_BCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_CCCH,		1,	L1SCHED_IDLE,		1 },
	{ L1SCHED_CCCH,		2,	L1SCHED_IDLE,		2 },
	{ L1SCHED_CCCH,		3,	L1SCHED_IDLE,		3 },
	{ L1SCHED_FCCH,		0,	L1SCHED_SACCH4_3,	0 },
	{ L1SCHED_SCH,		0,	L1SCHED_SACCH4_3,	1 },
	{ L1SCHED_CCCH,		0,	L1SCHED_SACCH4_3,	2 },
	{ L1SCHED_CCCH,		1,	L1SCHED_SACCH4_3,	3 },
	{ L1SCHED_CCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		1,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_FCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_0,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_0,	1,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_0,	2,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_0,	3,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_1,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_1,	1,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_1,	2,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_1,	3,	L1SCHED_RACH,		0 },
	{ L1SCHED_FCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_CBCH,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_CBCH,	1,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_CBCH,	2,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_CBCH,	3,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_3,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_3,	1,	L1SCHED_SDCCH4_0,	0 },
	{ L1SCHED_SDCCH4_3,	2,	L1SCHED_SDCCH4_0,	1 },
	{ L1SCHED_SDCCH4_3,	3,	L1SCHED_SDCCH4_0,	2 },
	{ L1SCHED_FCCH,		0,	L1SCHED_SDCCH4_0,	3 },
	{ L1SCHED_SCH,		0,	L1SCHED_SDCCH4_1,	0 },
	{ L1SCHED_SACCH4_0,	0,	L1SCHED_SDCCH4_1,	1 },
	{ L1SCHED_SACCH4_0,	1,	L1SCHED_SDCCH4_1,	2 },
	{ L1SCHED_SACCH4_0,	2,	L1SCHED_SDCCH4_1,	3 },
	{ L1SCHED_SACCH4_0,	3,	L1SCHED_RACH,		0 },
	{ L1SCHED_SACCH4_1,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SACCH4_1,	1,	L1SCHED_IDLE,		0 },
	{ L1SCHED_SACCH4_1,	2,	L1SCHED_IDLE,		1 },
	{ L1SCHED_SACCH4_1,	3,	L1SCHED_IDLE,		2 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		3 },

	{ L1SCHED_FCCH,		0,	L1SCHED_SDCCH4_3,	0 },
	{ L1SCHED_SCH,		0,	L1SCHED_SDCCH4_3,	1 },
	{ L1SCHED_BCCH,		0,	L1SCHED_SDCCH4_3,	2 },
	{ L1SCHED_BCCH,		1,	L1SCHED_SDCCH4_3,	3 },
	{ L1SCHED_BCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_BCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		0,	L1SCHED_SACCH4_0,	0 },
	{ L1SCHED_CCCH,		1,	L1SCHED_SACCH4_0,	1 },
	{ L1SCHED_CCCH,		2,	L1SCHED_SACCH4_0,	2 },
	{ L1SCHED_CCCH,		3,	L1SCHED_SACCH4_0,	3 },
	{ L1SCHED_FCCH,		0,	L1SCHED_SACCH4_1,	0 },
	{ L1SCHED_SCH,		0,	L1SCHED_SACCH4_1,	1 },
	{ L1SCHED_CCCH,		0,	L1SCHED_SACCH4_1,	2 },
	{ L1SCHED_CCCH,		1,	L1SCHED_SACCH4_1,	3 },
	{ L1SCHED_CCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		1,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		2,	L1SCHED_RACH,		0 },
	{ L1SCHED_CCCH,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_FCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_0,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_0,	1,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_0,	2,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_0,	3,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_1,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_1,	1,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_1,	2,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_1,	3,	L1SCHED_RACH,		0 },
	{ L1SCHED_FCCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SCH,		0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_CBCH,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_CBCH,	1,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_CBCH,	2,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_CBCH,	3,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_3,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SDCCH4_3,	1,	L1SCHED_SDCCH4_0,	0 },
	{ L1SCHED_SDCCH4_3,	2,	L1SCHED_SDCCH4_0,	1 },
	{ L1SCHED_SDCCH4_3,	3,	L1SCHED_SDCCH4_0,	2 },
	{ L1SCHED_FCCH,		0,	L1SCHED_SDCCH4_0,	3 },
	{ L1SCHED_SCH,		0,	L1SCHED_SDCCH4_1,	0 },
	{ L1SCHED_IDLE,		0,	L1SCHED_SDCCH4_1,	1 },
	{ L1SCHED_IDLE,		1,	L1SCHED_SDCCH4_1,	2 },
	{ L1SCHED_IDLE,		2,	L1SCHED_SDCCH4_1,	3 },
	{ L1SCHED_IDLE,		3,	L1SCHED_RACH,		0 },
	{ L1SCHED_SACCH4_3,	0,	L1SCHED_RACH,		0 },
	{ L1SCHED_SACCH4_3,	1,	L1SCHED_IDLE,		0 },
	{ L1SCHED_SACCH4_3,	2,	L1SCHED_IDLE,		1 },
	{ L1SCHED_SACCH4_3,	3,	L1SCHED_IDLE,		2 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		3 },
};

static const struct l1sched_tdma_frame frame_sdcch8[102] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_SDCCH8_0,	0,	L1SCHED_SACCH8_5,	0 },
	{ L1SCHED_SDCCH8_0,	1,	L1SCHED_SACCH8_5,	1 },
	{ L1SCHED_SDCCH8_0,	2,	L1SCHED_SACCH8_5,	2 },
	{ L1SCHED_SDCCH8_0,	3,	L1SCHED_SACCH8_5,	3 },
	{ L1SCHED_SDCCH8_1,	0,	L1SCHED_SACCH8_6,	0 },
	{ L1SCHED_SDCCH8_1,	1,	L1SCHED_SACCH8_6,	1 },
	{ L1SCHED_SDCCH8_1,	2,	L1SCHED_SACCH8_6,	2 },
	{ L1SCHED_SDCCH8_1,	3,	L1SCHED_SACCH8_6,	3 },
	{ L1SCHED_SDCCH8_2,	0,	L1SCHED_SACCH8_7,	0 },
	{ L1SCHED_SDCCH8_2,	1,	L1SCHED_SACCH8_7,	1 },
	{ L1SCHED_SDCCH8_2,	2,	L1SCHED_SACCH8_7,	2 },
	{ L1SCHED_SDCCH8_2,	3,	L1SCHED_SACCH8_7,	3 },
	{ L1SCHED_SDCCH8_3,	0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_SDCCH8_3,	1,	L1SCHED_IDLE,		0 },
	{ L1SCHED_SDCCH8_3,	2,	L1SCHED_IDLE,		0 },
	{ L1SCHED_SDCCH8_3,	3,	L1SCHED_SDCCH8_0,	0 },
	{ L1SCHED_SDCCH8_4,	0,	L1SCHED_SDCCH8_0,	1 },
	{ L1SCHED_SDCCH8_4,	1,	L1SCHED_SDCCH8_0,	2 },
	{ L1SCHED_SDCCH8_4,	2,	L1SCHED_SDCCH8_0,	3 },
	{ L1SCHED_SDCCH8_4,	3,	L1SCHED_SDCCH8_1,	0 },
	{ L1SCHED_SDCCH8_5,	0,	L1SCHED_SDCCH8_1,	1 },
	{ L1SCHED_SDCCH8_5,	1,	L1SCHED_SDCCH8_1,	2 },
	{ L1SCHED_SDCCH8_5,	2,	L1SCHED_SDCCH8_1,	3 },
	{ L1SCHED_SDCCH8_5,	3,	L1SCHED_SDCCH8_2,	0 },
	{ L1SCHED_SDCCH8_6,	0,	L1SCHED_SDCCH8_2,	1 },
	{ L1SCHED_SDCCH8_6,	1,	L1SCHED_SDCCH8_2,	2 },
	{ L1SCHED_SDCCH8_6,	2,	L1SCHED_SDCCH8_2,	3 },
	{ L1SCHED_SDCCH8_6,	3,	L1SCHED_SDCCH8_3,	0 },
	{ L1SCHED_SDCCH8_7,	0,	L1SCHED_SDCCH8_3,	1 },
	{ L1SCHED_SDCCH8_7,	1,	L1SCHED_SDCCH8_3,	2 },
	{ L1SCHED_SDCCH8_7,	2,	L1SCHED_SDCCH8_3,	3 },
	{ L1SCHED_SDCCH8_7,	3,	L1SCHED_SDCCH8_4,	0 },
	{ L1SCHED_SACCH8_0,	0,	L1SCHED_SDCCH8_4,	1 },
	{ L1SCHED_SACCH8_0,	1,	L1SCHED_SDCCH8_4,	2 },
	{ L1SCHED_SACCH8_0,	2,	L1SCHED_SDCCH8_4,	3 },
	{ L1SCHED_SACCH8_0,	3,	L1SCHED_SDCCH8_5,	0 },
	{ L1SCHED_SACCH8_1,	0,	L1SCHED_SDCCH8_5,	1 },
	{ L1SCHED_SACCH8_1,	1,	L1SCHED_SDCCH8_5,	2 },
	{ L1SCHED_SACCH8_1,	2,	L1SCHED_SDCCH8_5,	3 },
	{ L1SCHED_SACCH8_1,	3,	L1SCHED_SDCCH8_6,	0 },
	{ L1SCHED_SACCH8_2,	0,	L1SCHED_SDCCH8_6,	1 },
	{ L1SCHED_SACCH8_2,	1,	L1SCHED_SDCCH8_6,	2 },
	{ L1SCHED_SACCH8_2,	2,	L1SCHED_SDCCH8_6,	3 },
	{ L1SCHED_SACCH8_2,	3,	L1SCHED_SDCCH8_7,	0 },
	{ L1SCHED_SACCH8_3,	0,	L1SCHED_SDCCH8_7,	1 },
	{ L1SCHED_SACCH8_3,	1,	L1SCHED_SDCCH8_7,	2 },
	{ L1SCHED_SACCH8_3,	2,	L1SCHED_SDCCH8_7,	3 },
	{ L1SCHED_SACCH8_3,	3,	L1SCHED_SACCH8_0,	0 },
	{ L1SCHED_IDLE,		0,	L1SCHED_SACCH8_0,	1 },
	{ L1SCHED_IDLE,		0,	L1SCHED_SACCH8_0,	2 },
	{ L1SCHED_IDLE,		0,	L1SCHED_SACCH8_0,	3 },

	{ L1SCHED_SDCCH8_0,	0,	L1SCHED_SACCH8_1,	0 },
	{ L1SCHED_SDCCH8_0,	1,	L1SCHED_SACCH8_1,	1 },
	{ L1SCHED_SDCCH8_0,	2,	L1SCHED_SACCH8_1,	2 },
	{ L1SCHED_SDCCH8_0,	3,	L1SCHED_SACCH8_1,	3 },
	{ L1SCHED_SDCCH8_1,	0,	L1SCHED_SACCH8_2,	0 },
	{ L1SCHED_SDCCH8_1,	1,	L1SCHED_SACCH8_2,	1 },
	{ L1SCHED_SDCCH8_1,	2,	L1SCHED_SACCH8_2,	2 },
	{ L1SCHED_SDCCH8_1,	3,	L1SCHED_SACCH8_2,	3 },
	{ L1SCHED_SDCCH8_2,	0,	L1SCHED_SACCH8_3,	0 },
	{ L1SCHED_SDCCH8_2,	1,	L1SCHED_SACCH8_3,	1 },
	{ L1SCHED_SDCCH8_2,	2,	L1SCHED_SACCH8_3,	2 },
	{ L1SCHED_SDCCH8_2,	3,	L1SCHED_SACCH8_3,	3 },
	{ L1SCHED_SDCCH8_3,	0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_SDCCH8_3,	1,	L1SCHED_IDLE,		0 },
	{ L1SCHED_SDCCH8_3,	2,	L1SCHED_IDLE,		0 },
	{ L1SCHED_SDCCH8_3,	3,	L1SCHED_SDCCH8_0,	0 },
	{ L1SCHED_SDCCH8_4,	0,	L1SCHED_SDCCH8_0,	1 },
	{ L1SCHED_SDCCH8_4,	1,	L1SCHED_SDCCH8_0,	2 },
	{ L1SCHED_SDCCH8_4,	2,	L1SCHED_SDCCH8_0,	3 },
	{ L1SCHED_SDCCH8_4,	3,	L1SCHED_SDCCH8_1,	0 },
	{ L1SCHED_SDCCH8_5,	0,	L1SCHED_SDCCH8_1,	1 },
	{ L1SCHED_SDCCH8_5,	1,	L1SCHED_SDCCH8_1,	2 },
	{ L1SCHED_SDCCH8_5,	2,	L1SCHED_SDCCH8_1,	3 },
	{ L1SCHED_SDCCH8_5,	3,	L1SCHED_SDCCH8_2,	0 },
	{ L1SCHED_SDCCH8_6,	0,	L1SCHED_SDCCH8_2,	1 },
	{ L1SCHED_SDCCH8_6,	1,	L1SCHED_SDCCH8_2,	2 },
	{ L1SCHED_SDCCH8_6,	2,	L1SCHED_SDCCH8_2,	3 },
	{ L1SCHED_SDCCH8_6,	3,	L1SCHED_SDCCH8_3,	0 },
	{ L1SCHED_SDCCH8_7,	0,	L1SCHED_SDCCH8_3,	1 },
	{ L1SCHED_SDCCH8_7,	1,	L1SCHED_SDCCH8_3,	2 },
	{ L1SCHED_SDCCH8_7,	2,	L1SCHED_SDCCH8_3,	3 },
	{ L1SCHED_SDCCH8_7,	3,	L1SCHED_SDCCH8_4,	0 },
	{ L1SCHED_SACCH8_4,	0,	L1SCHED_SDCCH8_4,	1 },
	{ L1SCHED_SACCH8_4,	1,	L1SCHED_SDCCH8_4,	2 },
	{ L1SCHED_SACCH8_4,	2,	L1SCHED_SDCCH8_4,	3 },
	{ L1SCHED_SACCH8_4,	3,	L1SCHED_SDCCH8_5,	0 },
	{ L1SCHED_SACCH8_5,	0,	L1SCHED_SDCCH8_5,	1 },
	{ L1SCHED_SACCH8_5,	1,	L1SCHED_SDCCH8_5,	2 },
	{ L1SCHED_SACCH8_5,	2,	L1SCHED_SDCCH8_5,	3 },
	{ L1SCHED_SACCH8_5,	3,	L1SCHED_SDCCH8_6,	0 },
	{ L1SCHED_SACCH8_6,	0,	L1SCHED_SDCCH8_6,	1 },
	{ L1SCHED_SACCH8_6,	1,	L1SCHED_SDCCH8_6,	2 },
	{ L1SCHED_SACCH8_6,	2,	L1SCHED_SDCCH8_6,	3 },
	{ L1SCHED_SACCH8_6,	3,	L1SCHED_SDCCH8_7,	0 },
	{ L1SCHED_SACCH8_7,	0,	L1SCHED_SDCCH8_7,	1 },
	{ L1SCHED_SACCH8_7,	1,	L1SCHED_SDCCH8_7,	2 },
	{ L1SCHED_SACCH8_7,	2,	L1SCHED_SDCCH8_7,	3 },
	{ L1SCHED_SACCH8_7,	3,	L1SCHED_SACCH8_4,	0 },
	{ L1SCHED_IDLE,		0,	L1SCHED_SACCH8_4,	1 },
	{ L1SCHED_IDLE,		0,	L1SCHED_SACCH8_4,	2 },
	{ L1SCHED_IDLE,		0,	L1SCHED_SACCH8_4,	3 },
};

static const struct l1sched_tdma_frame frame_sdcch8_cbch[102] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_SDCCH8_0,	0,	L1SCHED_SACCH8_5,	0 },
	{ L1SCHED_SDCCH8_0,	1,	L1SCHED_SACCH8_5,	1 },
	{ L1SCHED_SDCCH8_0,	2,	L1SCHED_SACCH8_5,	2 },
	{ L1SCHED_SDCCH8_0,	3,	L1SCHED_SACCH8_5,	3 },
	{ L1SCHED_SDCCH8_1,	0,	L1SCHED_SACCH8_6,	0 },
	{ L1SCHED_SDCCH8_1,	1,	L1SCHED_SACCH8_6,	1 },
	{ L1SCHED_SDCCH8_1,	2,	L1SCHED_SACCH8_6,	2 },
	{ L1SCHED_SDCCH8_1,	3,	L1SCHED_SACCH8_6,	3 },
	{ L1SCHED_SDCCH8_CBCH,	0,	L1SCHED_SACCH8_7,	0 },
	{ L1SCHED_SDCCH8_CBCH,	1,	L1SCHED_SACCH8_7,	1 },
	{ L1SCHED_SDCCH8_CBCH,	2,	L1SCHED_SACCH8_7,	2 },
	{ L1SCHED_SDCCH8_CBCH,	3,	L1SCHED_SACCH8_7,	3 },
	{ L1SCHED_SDCCH8_3,	0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_SDCCH8_3,	1,	L1SCHED_IDLE,		0 },
	{ L1SCHED_SDCCH8_3,	2,	L1SCHED_IDLE,		0 },
	{ L1SCHED_SDCCH8_3,	3,	L1SCHED_SDCCH8_0,	0 },
	{ L1SCHED_SDCCH8_4,	0,	L1SCHED_SDCCH8_0,	1 },
	{ L1SCHED_SDCCH8_4,	1,	L1SCHED_SDCCH8_0,	2 },
	{ L1SCHED_SDCCH8_4,	2,	L1SCHED_SDCCH8_0,	3 },
	{ L1SCHED_SDCCH8_4,	3,	L1SCHED_SDCCH8_1,	0 },
	{ L1SCHED_SDCCH8_5,	0,	L1SCHED_SDCCH8_1,	1 },
	{ L1SCHED_SDCCH8_5,	1,	L1SCHED_SDCCH8_1,	2 },
	{ L1SCHED_SDCCH8_5,	2,	L1SCHED_SDCCH8_1,	3 },
	{ L1SCHED_SDCCH8_5,	3,	L1SCHED_IDLE,		0 },
	{ L1SCHED_SDCCH8_6,	0,	L1SCHED_IDLE,		1 },
	{ L1SCHED_SDCCH8_6,	1,	L1SCHED_IDLE,		2 },
	{ L1SCHED_SDCCH8_6,	2,	L1SCHED_IDLE,		3 },
	{ L1SCHED_SDCCH8_6,	3,	L1SCHED_SDCCH8_3,	0 },
	{ L1SCHED_SDCCH8_7,	0,	L1SCHED_SDCCH8_3,	1 },
	{ L1SCHED_SDCCH8_7,	1,	L1SCHED_SDCCH8_3,	2 },
	{ L1SCHED_SDCCH8_7,	2,	L1SCHED_SDCCH8_3,	3 },
	{ L1SCHED_SDCCH8_7,	3,	L1SCHED_SDCCH8_4,	0 },
	{ L1SCHED_SACCH8_0,	0,	L1SCHED_SDCCH8_4,	1 },
	{ L1SCHED_SACCH8_0,	1,	L1SCHED_SDCCH8_4,	2 },
	{ L1SCHED_SACCH8_0,	2,	L1SCHED_SDCCH8_4,	3 },
	{ L1SCHED_SACCH8_0,	3,	L1SCHED_SDCCH8_5,	0 },
	{ L1SCHED_SACCH8_1,	0,	L1SCHED_SDCCH8_5,	1 },
	{ L1SCHED_SACCH8_1,	1,	L1SCHED_SDCCH8_5,	2 },
	{ L1SCHED_SACCH8_1,	2,	L1SCHED_SDCCH8_5,	3 },
	{ L1SCHED_SACCH8_1,	3,	L1SCHED_SDCCH8_6,	0 },
	{ L1SCHED_IDLE,		0,	L1SCHED_SDCCH8_6,	1 },
	{ L1SCHED_IDLE,		1,	L1SCHED_SDCCH8_6,	2 },
	{ L1SCHED_IDLE,		2,	L1SCHED_SDCCH8_6,	3 },
	{ L1SCHED_IDLE,		3,	L1SCHED_SDCCH8_7,	0 },
	{ L1SCHED_SACCH8_3,	0,	L1SCHED_SDCCH8_7,	1 },
	{ L1SCHED_SACCH8_3,	1,	L1SCHED_SDCCH8_7,	2 },
	{ L1SCHED_SACCH8_3,	2,	L1SCHED_SDCCH8_7,	3 },
	{ L1SCHED_SACCH8_3,	3,	L1SCHED_SACCH8_0,	0 },
	{ L1SCHED_IDLE,		0,	L1SCHED_SACCH8_0,	1 },
	{ L1SCHED_IDLE,		0,	L1SCHED_SACCH8_0,	2 },
	{ L1SCHED_IDLE,		0,	L1SCHED_SACCH8_0,	3 },

	{ L1SCHED_SDCCH8_0,	0,	L1SCHED_SACCH8_1,	0 },
	{ L1SCHED_SDCCH8_0,	1,	L1SCHED_SACCH8_1,	1 },
	{ L1SCHED_SDCCH8_0,	2,	L1SCHED_SACCH8_1,	2 },
	{ L1SCHED_SDCCH8_0,	3,	L1SCHED_SACCH8_1,	3 },
	{ L1SCHED_SDCCH8_1,	0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_SDCCH8_1,	1,	L1SCHED_IDLE,		1 },
	{ L1SCHED_SDCCH8_1,	2,	L1SCHED_IDLE,		2 },
	{ L1SCHED_SDCCH8_1,	3,	L1SCHED_IDLE,		3 },
	{ L1SCHED_SDCCH8_CBCH,	0,	L1SCHED_SACCH8_3,	0 },
	{ L1SCHED_SDCCH8_CBCH,	1,	L1SCHED_SACCH8_3,	1 },
	{ L1SCHED_SDCCH8_CBCH,	2,	L1SCHED_SACCH8_3,	2 },
	{ L1SCHED_SDCCH8_CBCH,	3,	L1SCHED_SACCH8_3,	3 },
	{ L1SCHED_SDCCH8_3,	0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_SDCCH8_3,	1,	L1SCHED_IDLE,		0 },
	{ L1SCHED_SDCCH8_3,	2,	L1SCHED_IDLE,		0 },
	{ L1SCHED_SDCCH8_3,	3,	L1SCHED_SDCCH8_0,	0 },
	{ L1SCHED_SDCCH8_4,	0,	L1SCHED_SDCCH8_0,	1 },
	{ L1SCHED_SDCCH8_4,	1,	L1SCHED_SDCCH8_0,	2 },
	{ L1SCHED_SDCCH8_4,	2,	L1SCHED_SDCCH8_0,	3 },
	{ L1SCHED_SDCCH8_4,	3,	L1SCHED_SDCCH8_1,	0 },
	{ L1SCHED_SDCCH8_5,	0,	L1SCHED_SDCCH8_1,	1 },
	{ L1SCHED_SDCCH8_5,	1,	L1SCHED_SDCCH8_1,	2 },
	{ L1SCHED_SDCCH8_5,	2,	L1SCHED_SDCCH8_1,	3 },
	{ L1SCHED_SDCCH8_5,	3,	L1SCHED_IDLE,		0 },
	{ L1SCHED_SDCCH8_6,	0,	L1SCHED_IDLE,		1 },
	{ L1SCHED_SDCCH8_6,	1,	L1SCHED_IDLE,		2 },
	{ L1SCHED_SDCCH8_6,	2,	L1SCHED_IDLE,		3 },
	{ L1SCHED_SDCCH8_6,	3,	L1SCHED_SDCCH8_3,	0 },
	{ L1SCHED_SDCCH8_7,	0,	L1SCHED_SDCCH8_3,	1 },
	{ L1SCHED_SDCCH8_7,	1,	L1SCHED_SDCCH8_3,	2 },
	{ L1SCHED_SDCCH8_7,	2,	L1SCHED_SDCCH8_3,	3 },
	{ L1SCHED_SDCCH8_7,	3,	L1SCHED_SDCCH8_4,	0 },
	{ L1SCHED_SACCH8_4,	0,	L1SCHED_SDCCH8_4,	1 },
	{ L1SCHED_SACCH8_4,	1,	L1SCHED_SDCCH8_4,	2 },
	{ L1SCHED_SACCH8_4,	2,	L1SCHED_SDCCH8_4,	3 },
	{ L1SCHED_SACCH8_4,	3,	L1SCHED_SDCCH8_5,	0 },
	{ L1SCHED_SACCH8_5,	0,	L1SCHED_SDCCH8_5,	1 },
	{ L1SCHED_SACCH8_5,	1,	L1SCHED_SDCCH8_5,	2 },
	{ L1SCHED_SACCH8_5,	2,	L1SCHED_SDCCH8_5,	3 },
	{ L1SCHED_SACCH8_5,	3,	L1SCHED_SDCCH8_6,	0 },
	{ L1SCHED_SACCH8_6,	0,	L1SCHED_SDCCH8_6,	1 },
	{ L1SCHED_SACCH8_6,	1,	L1SCHED_SDCCH8_6,	2 },
	{ L1SCHED_SACCH8_6,	2,	L1SCHED_SDCCH8_6,	3 },
	{ L1SCHED_SACCH8_6,	3,	L1SCHED_SDCCH8_7,	0 },
	{ L1SCHED_SACCH8_7,	0,	L1SCHED_SDCCH8_7,	1 },
	{ L1SCHED_SACCH8_7,	1,	L1SCHED_SDCCH8_7,	2 },
	{ L1SCHED_SACCH8_7,	2,	L1SCHED_SDCCH8_7,	3 },
	{ L1SCHED_SACCH8_7,	3,	L1SCHED_SACCH8_4,	0 },
	{ L1SCHED_IDLE,		0,	L1SCHED_SACCH8_4,	1 },
	{ L1SCHED_IDLE,		0,	L1SCHED_SACCH8_4,	2 },
	{ L1SCHED_IDLE,		0,	L1SCHED_SACCH8_4,	3 },
};

static const struct l1sched_tdma_frame frame_tchf_ts0[104] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	0,	L1SCHED_SACCHTF,	0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	1,	L1SCHED_SACCHTF,	1 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	2,	L1SCHED_SACCHTF,	2 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	3,	L1SCHED_SACCHTF,	3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
};

static const struct l1sched_tdma_frame frame_tchf_ts1[104] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	0,	L1SCHED_SACCHTF,	0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	1,	L1SCHED_SACCHTF,	1 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	2,	L1SCHED_SACCHTF,	2 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	3,	L1SCHED_SACCHTF,	3 },
};

static const struct l1sched_tdma_frame frame_tchf_ts2[104] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	3,	L1SCHED_SACCHTF,	3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	0,	L1SCHED_SACCHTF,	0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	1,	L1SCHED_SACCHTF,	1 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	2,	L1SCHED_SACCHTF,	2 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
};

static const struct l1sched_tdma_frame frame_tchf_ts3[104] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	3,	L1SCHED_SACCHTF,	3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	0,	L1SCHED_SACCHTF,	0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	1,	L1SCHED_SACCHTF,	1 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	2,	L1SCHED_SACCHTF,	2 },
};

static const struct l1sched_tdma_frame frame_tchf_ts4[104] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	2,	L1SCHED_SACCHTF,	2 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	3,	L1SCHED_SACCHTF,	3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	0,	L1SCHED_SACCHTF,	0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	1,	L1SCHED_SACCHTF,	1 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
};

static const struct l1sched_tdma_frame frame_tchf_ts5[104] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	2,	L1SCHED_SACCHTF,	2 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	3,	L1SCHED_SACCHTF,	3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	0,	L1SCHED_SACCHTF,	0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	1,	L1SCHED_SACCHTF,	1 },
};

static const struct l1sched_tdma_frame frame_tchf_ts6[104] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	1,	L1SCHED_SACCHTF,	1 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	2,	L1SCHED_SACCHTF,	2 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	3,	L1SCHED_SACCHTF,	3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	0,	L1SCHED_SACCHTF,	0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
};

static const struct l1sched_tdma_frame frame_tchf_ts7[104] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	1,	L1SCHED_SACCHTF,	1 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	2,	L1SCHED_SACCHTF,	2 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	3,	L1SCHED_SACCHTF,	3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_TCHF,		0,	L1SCHED_TCHF,		0 },
	{ L1SCHED_TCHF,		1,	L1SCHED_TCHF,		1 },
	{ L1SCHED_TCHF,		2,	L1SCHED_TCHF,		2 },
	{ L1SCHED_TCHF,		3,	L1SCHED_TCHF,		3 },
	{ L1SCHED_SACCHTF,	0,	L1SCHED_SACCHTF,	0 },
};

static const struct l1sched_tdma_frame frame_tchh_ts01[104] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_0,	0,	L1SCHED_SACCHTH_0,	0 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_1,	0,	L1SCHED_SACCHTH_1,	0 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_0,	1,	L1SCHED_SACCHTH_0,	1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_1,	1,	L1SCHED_SACCHTH_1,	1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_0,	2,	L1SCHED_SACCHTH_0,	2 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_1,	2,	L1SCHED_SACCHTH_1,	2 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_0,	3,	L1SCHED_SACCHTH_0,	3 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_1,	3,	L1SCHED_SACCHTH_1,	3 },
};

static const struct l1sched_tdma_frame frame_tchh_ts23[104] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_0,	3,	L1SCHED_SACCHTH_0,	3 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_1,	3,	L1SCHED_SACCHTH_1,	3 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_0,	0,	L1SCHED_SACCHTH_0,	0 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_1,	0,	L1SCHED_SACCHTH_1,	0 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_0,	1,	L1SCHED_SACCHTH_0,	1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_1,	1,	L1SCHED_SACCHTH_1,	1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_0,	2,	L1SCHED_SACCHTH_0,	2 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_1,	2,	L1SCHED_SACCHTH_1,	2 },
};

static const struct l1sched_tdma_frame frame_tchh_ts45[104] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_0,	2,	L1SCHED_SACCHTH_0,	2 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_1,	2,	L1SCHED_SACCHTH_1,	2 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_0,	3,	L1SCHED_SACCHTH_0,	3 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_1,	3,	L1SCHED_SACCHTH_1,	3 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_0,	0,	L1SCHED_SACCHTH_0,	0 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_1,	0,	L1SCHED_SACCHTH_1,	0 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_0,	1,	L1SCHED_SACCHTH_0,	1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_1,	1,	L1SCHED_SACCHTH_1,	1 },
};

static const struct l1sched_tdma_frame frame_tchh_ts67[104] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_0,	1,	L1SCHED_SACCHTH_0,	1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_1,	1,	L1SCHED_SACCHTH_1,	1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_0,	2,	L1SCHED_SACCHTH_0,	2 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_1,	2,	L1SCHED_SACCHTH_1,	2 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_0,	3,	L1SCHED_SACCHTH_0,	3 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_1,	3,	L1SCHED_SACCHTH_1,	3 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_0,	0,	L1SCHED_SACCHTH_0,	0 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_TCHH_0,	0,	L1SCHED_TCHH_0,		0 },
	{ L1SCHED_TCHH_1,	0,	L1SCHED_TCHH_1,		0 },
	{ L1SCHED_TCHH_0,	1,	L1SCHED_TCHH_0,		1 },
	{ L1SCHED_TCHH_1,	1,	L1SCHED_TCHH_1,		1 },
	{ L1SCHED_SACCHTH_1,	0,	L1SCHED_SACCHTH_1,	0 },
};

static const struct l1sched_tdma_frame frame_pdch[104] = {
	/* dl_chan		dl_bid	ul_chan			ul_bid */
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PTCCH,	0,	L1SCHED_PTCCH,		0 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PTCCH,	1,	L1SCHED_PTCCH,		1 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PTCCH,	2,	L1SCHED_PTCCH,		2 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PTCCH,	3,	L1SCHED_PTCCH,		3 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_PDTCH,	0,	L1SCHED_PDTCH,		0 },
	{ L1SCHED_PDTCH,	1,	L1SCHED_PDTCH,		1 },
	{ L1SCHED_PDTCH,	2,	L1SCHED_PDTCH,		2 },
	{ L1SCHED_PDTCH,	3,	L1SCHED_PDTCH,		3 },
	{ L1SCHED_IDLE,		0,	L1SCHED_IDLE,		0 },
};

/* Logical channel mask for a single channel */
#define M64(x) \
	((uint64_t) 0x01 << x)

/* Logical channel mask for BCCH+CCCH */
#define M64_BCCH_CCCH \
	(uint64_t) 0x00 \
		| M64(L1SCHED_FCCH) \
		| M64(L1SCHED_SCH)  \
		| M64(L1SCHED_BCCH) \
		| M64(L1SCHED_RACH) \
		| M64(L1SCHED_CCCH)

/* Logical channel mask for SDCCH4 (with SACCH, all sub-channels) */
#define M64_SDCCH4 \
	(uint64_t) 0x00 \
		| M64(L1SCHED_SDCCH4_0) | M64(L1SCHED_SACCH4_0) \
		| M64(L1SCHED_SDCCH4_1) | M64(L1SCHED_SACCH4_1) \
		| M64(L1SCHED_SDCCH4_2) | M64(L1SCHED_SACCH4_2) \
		| M64(L1SCHED_SDCCH4_3) | M64(L1SCHED_SACCH4_3)

/* Logical channel mask for SDCCH8 (with SACCH, all sub-channels) */
#define M64_SDCCH8 \
	(uint64_t) 0x00 \
		| M64(L1SCHED_SDCCH8_0) | M64(L1SCHED_SACCH8_0) \
		| M64(L1SCHED_SDCCH8_1) | M64(L1SCHED_SACCH8_1) \
		| M64(L1SCHED_SDCCH8_2) | M64(L1SCHED_SACCH8_2) \
		| M64(L1SCHED_SDCCH8_3) | M64(L1SCHED_SACCH8_3) \
		| M64(L1SCHED_SDCCH8_4) | M64(L1SCHED_SACCH8_4) \
		| M64(L1SCHED_SDCCH8_5) | M64(L1SCHED_SACCH8_5) \
		| M64(L1SCHED_SDCCH8_6) | M64(L1SCHED_SACCH8_6) \
		| M64(L1SCHED_SDCCH8_7) | M64(L1SCHED_SACCH8_7)

/* Logical channel mask for TCH/F (with SACCH) */
#define M64_TCHF \
	(uint64_t) 0x00 \
		| M64(L1SCHED_TCHF) | M64(L1SCHED_SACCHTF)

/* Logical channel mask for TCH/H (with SACCH, all sub-channels) */
#define M64_TCHH \
	(uint64_t) 0x00 \
		| M64(L1SCHED_TCHH_0) | M64(L1SCHED_SACCHTH_0) \
		| M64(L1SCHED_TCHH_1) | M64(L1SCHED_SACCHTH_1)

/**
 * A few notes about frame count:
 *
 * 26 frame multiframe - traffic multiframe
 * 51 frame multiframe - control multiframe
 *
 * 102 = 2 x 51 frame multiframe
 * 104 = 4 x 26 frame multiframe
 */
static const struct l1sched_tdma_multiframe layouts[] = {
	{
		GSM_PCHAN_NONE, "NONE",
		0,	0xff,
		0x00,
		NULL
	},
	{
		GSM_PCHAN_CCCH, "BCCH+CCCH",
		51,	0xff,
		M64_BCCH_CCCH,
		frame_bcch
	},
	{
		GSM_PCHAN_CCCH_SDCCH4, "BCCH+CCCH+SDCCH/4+SACCH/4",
		102,	0xff,
		M64_BCCH_CCCH | M64_SDCCH4,
		frame_bcch_sdcch4
	},
	{
		GSM_PCHAN_CCCH_SDCCH4_CBCH, "BCCH+CCCH+SDCCH/4+SACCH/4+CBCH",
		102,	0xff,
		M64_BCCH_CCCH | M64_SDCCH4 | M64(L1SCHED_SDCCH4_CBCH),
		frame_bcch_sdcch4_cbch
	},
	{
		GSM_PCHAN_SDCCH8_SACCH8C, "SDCCH/8+SACCH/8",
		102,	0xff,
		M64_SDCCH8,
		frame_sdcch8
	},
	{
		GSM_PCHAN_SDCCH8_SACCH8C_CBCH, "SDCCH/8+SACCH/8+CBCH",
		102,	0xff,
		M64_SDCCH8 | M64(L1SCHED_SDCCH8_CBCH),
		frame_sdcch8_cbch
	},
	{
		GSM_PCHAN_TCH_F, "TCH/F+SACCH",
		104,	0x01,
		M64_TCHF,
		frame_tchf_ts0
	},
	{
		GSM_PCHAN_TCH_F, "TCH/F+SACCH",
		104,	0x02,
		M64_TCHF,
		frame_tchf_ts1
	},
	{
		GSM_PCHAN_TCH_F, "TCH/F+SACCH",
		104,	0x04,
		M64_TCHF,
		frame_tchf_ts2
	},
	{
		GSM_PCHAN_TCH_F, "TCH/F+SACCH",
		104,	0x08,
		M64_TCHF,
		frame_tchf_ts3
	},
	{
		GSM_PCHAN_TCH_F, "TCH/F+SACCH",
		104,	0x10,
		M64_TCHF,
		frame_tchf_ts4
	},
	{
		GSM_PCHAN_TCH_F, "TCH/F+SACCH",
		104,	0x20,
		M64_TCHF,
		frame_tchf_ts5
	},
	{
		GSM_PCHAN_TCH_F, "TCH/F+SACCH",
		104,	0x40,
		M64_TCHF,
		frame_tchf_ts6
	},
	{
		GSM_PCHAN_TCH_F, "TCH/F+SACCH",
		104,	0x80,
		M64_TCHF,
		frame_tchf_ts7
	},
	{
		GSM_PCHAN_TCH_H, "TCH/H+SACCH",
		104,	0x03,
		M64_TCHH,
		frame_tchh_ts01
	},
	{
		GSM_PCHAN_TCH_H, "TCH/H+SACCH",
		104,	0x0c,
		M64_TCHH,
		frame_tchh_ts23
	},
	{
		GSM_PCHAN_TCH_H, "TCH/H+SACCH",
		104,	0x30,
		M64_TCHH,
		frame_tchh_ts45
	},
	{
		GSM_PCHAN_TCH_H, "TCH/H+SACCH",
		104,	0xc0,
		M64_TCHH,
		frame_tchh_ts67
	},
	{
		GSM_PCHAN_PDCH, "PDCH",
		104,	0xff,
		M64(L1SCHED_PDTCH) | M64(L1SCHED_PTCCH),
		frame_pdch
	},
};

const struct l1sched_tdma_multiframe *l1sched_mframe_layout(
	enum gsm_phys_chan_config config, int tn)
{
	int i, ts_allowed;

	for (i = 0; i < ARRAY_SIZE(layouts); i++) {
		ts_allowed = layouts[i].slotmask & (0x01 << tn);
		if (layouts[i].chan_config == config && ts_allowed)
			return &layouts[i];
	}

	return NULL;
}
