/*
 * (C) 2021-2022 by sysmocom - s.f.m.c. GmbH <info@sysmocom.de>
 * All Rights Reserved.
 *
 * Author: Neels Janosch Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * SPDX-License-Identifier: GPL-2.0+
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#pragma once

#include <stdint.h>

#include <osmocom/core/socket.h>

#define NFT_CHAIN_NAME_PREFIX_TUNMAP "tunmap"

struct upf_nft_tunmap_desc {
	struct {
		struct osmo_sockaddr gtp_remote_addr;
		uint32_t local_teid;
		uint32_t remote_teid;
	} access;
	struct {
		struct osmo_sockaddr gtp_remote_addr;
		uint32_t local_teid;
		uint32_t remote_teid;
	} core;
	uint32_t id;
};

int upf_nft_init();
int upf_nft_free();

int upf_nft_tunmap_create(struct upf_nft_tunmap_desc *tunmap);
int upf_nft_tunmap_delete(struct upf_nft_tunmap_desc *tunmap);
