/*
 * (C) 2021-2022 by sysmocom - s.f.m.c. GmbH <info@sysmocom.de>
 * All Rights Reserved.
 *
 * Author: Neels Janosch Hofmeyr <nhofmeyr@sysmocom.de>
 *
 * SPDX-License-Identifier: GPL-2.0+
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#pragma once

#include <osmocom/core/linuxlist.h>
#include <osmocom/core/select.h>
#include <osmocom/core/logging.h>

#define LOG_GTP_DEV(DEV, LEVEL, FMT, ARGS...) \
	LOGP(DGTP, LEVEL, "%s: " FMT, upf_gtp_dev_to_str_c(OTC_SELECT, (DEV)), ##ARGS)

#define PORT_GTP0_C 3386
#define PORT_GTP0_U 3386

#define PORT_GTP1_C 2123
#define PORT_GTP1_U 2152

struct upf_gtp_dev {
	struct llist_head entry;

	/* If true, osmo-upf created this GTP device on startup and will destroy it on program exit. If false, the user
	 * has created the device and osmo-upf will not destroy it. */
	bool created;

	char *name;
	struct {
		bool enabled;
		struct osmo_sockaddr local_addr;
		struct osmo_fd ofd;
	} gtpv0;
	struct {
		struct osmo_sockaddr local_addr;
		struct osmo_fd ofd;
	} gtpv1;
	bool sgsn_mode;

	uint32_t ifidx;

	struct llist_head tunnels;
};

struct upf_gtp_tun_desc {
	uint32_t local_teid;
	uint32_t remote_teid;
	struct osmo_sockaddr ue_addr;
	struct osmo_sockaddr gtp_remote_addr;
};

int upf_gtp_tun_desc_cmp(const struct upf_gtp_tun_desc *a, const struct upf_gtp_tun_desc *b);

int upf_gtp_genl_open();
void upf_gtp_genl_close();

int upf_gtp_dev_open(const char *name, bool create_gtp_dev, const char *local_addr, bool listen_for_gtpv0,
		     bool sgsn_mode);
struct upf_gtp_dev *upf_gtp_dev_find_by_name(const char *name);
struct upf_gtp_dev *upf_gtp_dev_first();

int upf_gtp_dev_tunnel_add(struct upf_gtp_dev *dev, const struct upf_gtp_tun_desc *t);
bool upf_gtp_dev_is_tunnel_active(struct upf_gtp_dev *dev, const struct upf_gtp_tun_desc *t);
int upf_gtp_dev_tunnel_del(struct upf_gtp_dev *dev, const struct upf_gtp_tun_desc *t);

int upf_gtp_dev_to_str_buf(char *buf, size_t buflen, const struct upf_gtp_dev *dev);
char *upf_gtp_dev_to_str_c(void *ctx, const struct upf_gtp_dev *dev);
