/***************************************************************************//**
 *   @file   AD9548.h
 *   @brief  Header file of AD9548 Driver.
 *   @author DBogdan (dragos.bogdan@analog.com)
********************************************************************************
 * Copyright 2012(c) Analog Devices, Inc.
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  - Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *  - Neither the name of Analog Devices, Inc. nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *  - The use of this software may or may not infringe the patent rights
 *    of one or more patent holders.  This license does not release you
 *    from the requirement that you obtain separate licenses from these
 *    patent holders to use this software.
 *  - Use of the software either in source or binary form, must be run
 *    on or directly connected to an Analog Devices Inc. component.
 *
 * THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
********************************************************************************
 *   SVN Revision: $WCREV$
*******************************************************************************/
#ifndef __AD9548_H__
#define __AD9548_H__

/*****************************************************************************/
/***************************** Include Files *********************************/
/*****************************************************************************/
#include <stdint.h>

/******************************************************************************/
/************************ AD9548 **********************************************/
/******************************************************************************/
/* Registers */

/* Serial port control and part identification */
#define AD9548_REG_SPI_CTRL								0x0000
#define AD9548_REG_I2C_CTRL								0x0001
#define AD9548_REG_SILICON_REV_NUMBER					0x0002
#define AD9548_REG_DEVICE_ID							0x0003
#define AD9548_REG_READBACK								0x0004
#define AD9548_REG_IO_UPDATE							0x0005

/* System clock */
#define AD9548_REG_SYSCLK_0								0x0100
#define AD9548_REG_SYSCLK_1								0x0101
#define AD9548_REG_SYSCLK_2								0x0102
#define AD9548_REG_NOM_SYSCLK_PERIOD_0					0x0103
#define AD9548_REG_NOM_SYSCLK_PERIOD_1					0x0104
#define AD9548_REG_NOM_SYSCLK_PERIOD_2					0x0105
#define AD9548_REG_SYSTEM_CLK_STABILITY_0				0x0106
#define AD9548_REG_SYSTEM_CLK_STABILITY_1				0x0107
#define AD9548_REG_SYSTEM_CLK_STABILITY_2				0x0108

/* General configuration */
#define AD9548_REG_M0									0x0200
#define AD9548_REG_M1									0x0201
#define AD9548_REG_M2									0x0202
#define AD9548_REG_M3									0x0203
#define AD9548_REG_M4									0x0204
#define AD9548_REG_M5									0x0205
#define AD9548_REG_M6									0x0206
#define AD9548_REG_M7									0x0207
#define AD9548_REG_IRQ_PIN_OUTPUT_MODE					0x0208
#define AD9548_REG_IRQ_MASK_0							0x0209
#define AD9548_REG_IRQ_MASK_1							0x020A
#define AD9548_REG_IRQ_MASK_2							0x020B
#define AD9548_REG_IRQ_MASK_3							0x020C
#define AD9548_REG_IRQ_MASK_4							0x020D
#define AD9548_REG_IRQ_MASK_5							0x020E
#define AD9548_REG_IRQ_MASK_6							0x020F
#define AD9548_REG_IRQ_MASK_7							0x0210
#define AD9548_REG_WATCHDOG_TIMER_0						0x0211
#define AD9548_REG_WATCHDOG_TIMER_1						0x0212
#define AD9548_REG_DAC_CURRENT_0						0x0213
#define AD9548_REG_DAC_CURRENT_1						0x0214

/* DPLL */
#define AD9548_REG_TUNING_WORD_0		                0x0300
#define AD9548_REG_TUNING_WORD_1		                0x0301
#define AD9548_REG_TUNING_WORD_2		                0x0302
#define AD9548_REG_TUNING_WORD_3		                0x0303
#define AD9548_REG_TUNING_WORD_4		                0x0304
#define AD9548_REG_TUNING_WORD_5		                0x0305
#define AD9548_REG_UPDATE_TW							0x0306
#define AD9548_REG_PULL_IN_RANGE_LIMITS_0				0x0307
#define AD9548_REG_PULL_IN_RANGE_LIMITS_1				0x0308
#define AD9548_REG_PULL_IN_RANGE_LIMITS_2				0x0309
#define AD9548_REG_PULL_IN_RANGE_LIMITS_3				0x030A
#define AD9548_REG_PULL_IN_RANGE_LIMITS_4				0x030B
#define AD9548_REG_PULL_IN_RANGE_LIMITS_5				0x030C
#define AD9548_REG_OPEN_LOOP_PHASE_OFFSET_0				0x030D
#define AD9548_REG_OPEN_LOOP_PHASE_OFFSET_1				0x030E
#define AD9548_REG_CLOSED_LOOP_PHASE_LOCK_OFFSET_0		0x030F
#define AD9548_REG_CLOSED_LOOP_PHASE_LOCK_OFFSET_1		0x0310
#define AD9548_REG_CLOSED_LOOP_PHASE_LOCK_OFFSET_2		0x0311
#define AD9548_REG_CLOSED_LOOP_PHASE_LOCK_OFFSET_3		0x0312
#define AD9548_REG_CLOSED_LOOP_PHASE_LOCK_OFFSET_4		0x0313
#define AD9548_REG_INCREMENTAL_PHASE_LOCK_OFFSET_1		0x0314
#define AD9548_REG_INCREMENTAL_PHASE_LOCK_OFFSET_2		0x0315
#define AD9548_REG_PHASE_SLEW_LIMIT_0					0x0316
#define AD9548_REG_PHASE_SLEW_LIMIT_1					0x0317
#define AD9548_REG_HISTORY_ACCUMULATION_TIMER_0			0x0318
#define AD9548_REG_HISTORY_ACCUMULATION_TIMER_1			0x0319
#define AD9548_REG_HISTORY_ACCUMULATION_TIMER_2			0x031A
#define AD9548_REG_HISTORY_MODE							0x031B

/* Clock distribution output */
#define AD9548_REG_DISTRIBUTION_SETTINGS				0x0400
#define AD9548_REG_DISTRIBUTION_ENABLE					0x0401
#define AD9548_REG_DISTRIBUTION_SYNCRONIZATION			0x0402
#define AD9548_REG_AUTOMATIC_SYNCRONIZATION				0x0403
#define AD9548_REG_DISTRIBUTION_CHANNEL_MODES_0			0x0404
#define AD9548_REG_DISTRIBUTION_CHANNEL_MODES_1			0x0405
#define AD9548_REG_DISTRIBUTION_CHANNEL_MODES_2			0x0406
#define AD9548_REG_DISTRIBUTION_CHANNEL_MODES_3			0x0407
#define AD9548_REG_DISTRIBUTION_CHANNEL_DIVIDERS_0		0x0408
#define AD9548_REG_DISTRIBUTION_CHANNEL_DIVIDERS_1		0x0409
#define AD9548_REG_DISTRIBUTION_CHANNEL_DIVIDERS_2		0x040A
#define AD9548_REG_DISTRIBUTION_CHANNEL_DIVIDERS_3		0x040B
#define AD9548_REG_DISTRIBUTION_CHANNEL_DIVIDERS_4		0x040C
#define AD9548_REG_DISTRIBUTION_CHANNEL_DIVIDERS_5		0x040D
#define AD9548_REG_DISTRIBUTION_CHANNEL_DIVIDERS_6		0x040E
#define AD9548_REG_DISTRIBUTION_CHANNEL_DIVIDERS_7		0x040F
#define AD9548_REG_DISTRIBUTION_CHANNEL_DIVIDERS_8		0x0410
#define AD9548_REG_DISTRIBUTION_CHANNEL_DIVIDERS_9		0x0411
#define AD9548_REG_DISTRIBUTION_CHANNEL_DIVIDERS_10		0x0412
#define AD9548_REG_DISTRIBUTION_CHANNEL_DIVIDERS_11		0x0413
#define AD9548_REG_DISTRIBUTION_CHANNEL_DIVIDERS_12		0x0414
#define AD9548_REG_DISTRIBUTION_CHANNEL_DIVIDERS_13		0x0415
#define AD9548_REG_DISTRIBUTION_CHANNEL_DIVIDERS_14		0x0416
#define AD9548_REG_DISTRIBUTION_CHANNEL_DIVIDERS_15		0x0417

/* Reference inputs */
#define AD9548_REG_REFERENCE_POWER_DOWN					0x0500
#define AD9548_REG_REFERENCE_LOGIC_FAMILY_0				0x0501
#define AD9548_REG_REFERENCE_LOGIC_FAMILY_1				0x0502
#define AD9548_REG_MANUAL_REFERENCE_PROFILE_SEL_0		0x0503
#define AD9548_REG_MANUAL_REFERENCE_PROFILE_SEL_1		0x0504
#define AD9548_REG_MANUAL_REFERENCE_PROFILE_SEL_2		0x0505
#define AD9548_REG_MANUAL_REFERENCE_PROFILE_SEL_3		0x0506
#define AD9548_REG_PHASE_BUILD_OUT_SWITCHING			0x0507

/* Profile 0 */
#define AD9548_REG_PROFILE_0_PRIORITIES					0x0600
#define AD9548_REG_PROFILE_0_REFERENCE_PERIOD_0			0x0601
#define AD9548_REG_PROFILE_0_REFERENCE_PERIOD_1			0x0602
#define AD9548_REG_PROFILE_0_REFERENCE_PERIOD_2			0x0603
#define AD9548_REG_PROFILE_0_REFERENCE_PERIOD_3			0x0604
#define AD9548_REG_PROFILE_0_REFERENCE_PERIOD_4			0x0605
#define AD9548_REG_PROFILE_0_REFERENCE_PERIOD_5			0x0606
#define AD9548_REG_PROFILE_0_REFERENCE_PERIOD_6			0x0607
#define AD9548_REG_PROFILE_0_TOLERANCE_0				0x0608
#define AD9548_REG_PROFILE_0_TOLERANCE_1				0x0609
#define AD9548_REG_PROFILE_0_TOLERANCE_2				0x060A
#define AD9548_REG_PROFILE_0_TOLERANCE_3				0x060B
#define AD9548_REG_PROFILE_0_TOLERANCE_4				0x060C
#define AD9548_REG_PROFILE_0_TOLERANCE_5				0x060D
#define AD9548_REG_PROFILE_0_VALIDATION_0				0x060E
#define AD9548_REG_PROFILE_0_VALIDATION_1				0x060F
#define AD9548_REG_PROFILE_0_REDETECT_TIMEOUT_0			0x0610
#define AD9548_REG_PROFILE_0_REDETECT_TIMEOUT_1			0x0611
#define AD9548_REG_PROFILE_0_D_LOOP_FILTER_COEFF_0		0x0612
#define AD9548_REG_PROFILE_0_D_LOOP_FILTER_COEFF_1		0x0613
#define AD9548_REG_PROFILE_0_D_LOOP_FILTER_COEFF_2		0x0614
#define AD9548_REG_PROFILE_0_D_LOOP_FILTER_COEFF_3		0x0615
#define AD9548_REG_PROFILE_0_D_LOOP_FILTER_COEFF_4		0x0616
#define AD9548_REG_PROFILE_0_D_LOOP_FILTER_COEFF_5		0x0617
#define AD9548_REG_PROFILE_0_D_LOOP_FILTER_COEFF_6		0x0618
#define AD9548_REG_PROFILE_0_D_LOOP_FILTER_COEFF_7		0x0619
#define AD9548_REG_PROFILE_0_D_LOOP_FILTER_COEFF_8		0x061A
#define AD9548_REG_PROFILE_0_D_LOOP_FILTER_COEFF_9		0x061B
#define AD9548_REG_PROFILE_0_D_LOOP_FILTER_COEFF_10		0x061C
#define AD9548_REG_PROFILE_0_D_LOOP_FILTER_COEFF_11		0x061D
#define AD9548_REG_PROFILE_0_FREQ_MULTIPLICATION_0		0x061E
#define AD9548_REG_PROFILE_0_FREQ_MULTIPLICATION_1		0x061F
#define AD9548_REG_PROFILE_0_FREQ_MULTIPLICATION_2		0x0620
#define AD9548_REG_PROFILE_0_FREQ_MULTIPLICATION_3		0x0621
#define AD9548_REG_PROFILE_0_FREQ_MULTIPLICATION_4		0x0622
#define AD9548_REG_PROFILE_0_FREQ_MULTIPLICATION_5		0x0623
#define AD9548_REG_PROFILE_0_FREQ_MULTIPLICATION_6		0x0624
#define AD9548_REG_PROFILE_0_FREQ_MULTIPLICATION_7		0x0625
#define AD9548_REG_PROFILE_0_FREQ_MULTIPLICATION_8		0x0626
#define AD9548_REG_PROFILE_0_FREQ_MULTIPLICATION_9		0x0627
#define AD9548_REG_PROFILE_0_FREQ_MULTIPLICATION_10		0x0628
#define AD9548_REG_PROFILE_0_FREQ_LOCK_DETECTORS_0		0x0629
#define AD9548_REG_PROFILE_0_FREQ_LOCK_DETECTORS_1		0x062A
#define AD9548_REG_PROFILE_0_FREQ_LOCK_DETECTORS_2		0x062B
#define AD9548_REG_PROFILE_0_FREQ_LOCK_DETECTORS_3		0x062C
#define AD9548_REG_PROFILE_0_FREQ_LOCK_DETECTORS_4		0x062D
#define AD9548_REG_PROFILE_0_FREQ_LOCK_DETECTORS_5		0x062E
#define AD9548_REG_PROFILE_0_FREQ_LOCK_DETECTORS_6		0x062F
#define AD9548_REG_PROFILE_0_FREQ_LOCK_DETECTORS_7		0x0630
#define AD9548_REG_PROFILE_0_FREQ_LOCK_DETECTORS_8		0x0631

/* Profile 1 */
#define AD9548_REG_PROFILE_1_PRIORITIES					0x0632
#define AD9548_REG_PROFILE_1_REFERENCE_PERIOD_0			0x0633
#define AD9548_REG_PROFILE_1_REFERENCE_PERIOD_1			0x0634
#define AD9548_REG_PROFILE_1_REFERENCE_PERIOD_2			0x0635
#define AD9548_REG_PROFILE_1_REFERENCE_PERIOD_3			0x0636
#define AD9548_REG_PROFILE_1_REFERENCE_PERIOD_4			0x0637
#define AD9548_REG_PROFILE_1_REFERENCE_PERIOD_5			0x0638
#define AD9548_REG_PROFILE_1_REFERENCE_PERIOD_6			0x0639
#define AD9548_REG_PROFILE_1_TOLERANCE_0				0x063A
#define AD9548_REG_PROFILE_1_TOLERANCE_1				0x063B
#define AD9548_REG_PROFILE_1_TOLERANCE_2				0x063C
#define AD9548_REG_PROFILE_1_TOLERANCE_3				0x063D
#define AD9548_REG_PROFILE_1_TOLERANCE_4				0x063E
#define AD9548_REG_PROFILE_1_TOLERANCE_5				0x063F
#define AD9548_REG_PROFILE_1_VALIDATION_0				0x0640
#define AD9548_REG_PROFILE_1_VALIDATION_1				0x0641
#define AD9548_REG_PROFILE_1_REDETECT_TIMEOUT_0			0x0642
#define AD9548_REG_PROFILE_1_REDETECT_TIMEOUT_1			0x0643
#define AD9548_REG_PROFILE_1_D_LOOP_FILTER_COEFF_0		0x0644
#define AD9548_REG_PROFILE_1_D_LOOP_FILTER_COEFF_1		0x0645
#define AD9548_REG_PROFILE_1_D_LOOP_FILTER_COEFF_2		0x0646
#define AD9548_REG_PROFILE_1_D_LOOP_FILTER_COEFF_3		0x0647
#define AD9548_REG_PROFILE_1_D_LOOP_FILTER_COEFF_4		0x0648
#define AD9548_REG_PROFILE_1_D_LOOP_FILTER_COEFF_5		0x0649
#define AD9548_REG_PROFILE_1_D_LOOP_FILTER_COEFF_6		0x064A
#define AD9548_REG_PROFILE_1_D_LOOP_FILTER_COEFF_7		0x064B
#define AD9548_REG_PROFILE_1_D_LOOP_FILTER_COEFF_8		0x064C
#define AD9548_REG_PROFILE_1_D_LOOP_FILTER_COEFF_9		0x064D
#define AD9548_REG_PROFILE_1_D_LOOP_FILTER_COEFF_10		0x064E
#define AD9548_REG_PROFILE_1_D_LOOP_FILTER_COEFF_11		0x064F
#define AD9548_REG_PROFILE_1_FREQ_MULTIPLICATION_0		0x0650
#define AD9548_REG_PROFILE_1_FREQ_MULTIPLICATION_1		0x0651
#define AD9548_REG_PROFILE_1_FREQ_MULTIPLICATION_2		0x0652
#define AD9548_REG_PROFILE_1_FREQ_MULTIPLICATION_3		0x0653
#define AD9548_REG_PROFILE_1_FREQ_MULTIPLICATION_4		0x0654
#define AD9548_REG_PROFILE_1_FREQ_MULTIPLICATION_5		0x0655
#define AD9548_REG_PROFILE_1_FREQ_MULTIPLICATION_6		0x0656
#define AD9548_REG_PROFILE_1_FREQ_MULTIPLICATION_7		0x0657
#define AD9548_REG_PROFILE_1_FREQ_MULTIPLICATION_8		0x0658
#define AD9548_REG_PROFILE_1_FREQ_MULTIPLICATION_9		0x0659
#define AD9548_REG_PROFILE_1_FREQ_MULTIPLICATION_10		0x065A
#define AD9548_REG_PROFILE_1_FREQ_LOCK_DETECTORS_0		0x065B
#define AD9548_REG_PROFILE_1_FREQ_LOCK_DETECTORS_1		0x065C
#define AD9548_REG_PROFILE_1_FREQ_LOCK_DETECTORS_2		0x065D
#define AD9548_REG_PROFILE_1_FREQ_LOCK_DETECTORS_3		0x065E
#define AD9548_REG_PROFILE_1_FREQ_LOCK_DETECTORS_4		0x065F
#define AD9548_REG_PROFILE_1_FREQ_LOCK_DETECTORS_5		0x0660
#define AD9548_REG_PROFILE_1_FREQ_LOCK_DETECTORS_6		0x0661
#define AD9548_REG_PROFILE_1_FREQ_LOCK_DETECTORS_7		0x0662
#define AD9548_REG_PROFILE_1_FREQ_LOCK_DETECTORS_8		0x0663

/* Profile 2 */
#define AD9548_REG_PROFILE_2_PRIORITIES					0x0680
#define AD9548_REG_PROFILE_2_REFERENCE_PERIOD_0			0x0681
#define AD9548_REG_PROFILE_2_REFERENCE_PERIOD_1			0x0682
#define AD9548_REG_PROFILE_2_REFERENCE_PERIOD_2			0x0683
#define AD9548_REG_PROFILE_2_REFERENCE_PERIOD_3			0x0684
#define AD9548_REG_PROFILE_2_REFERENCE_PERIOD_4			0x0685
#define AD9548_REG_PROFILE_2_REFERENCE_PERIOD_5			0x0686
#define AD9548_REG_PROFILE_2_REFERENCE_PERIOD_6			0x0687
#define AD9548_REG_PROFILE_2_TOLERANCE_0				0x0688
#define AD9548_REG_PROFILE_2_TOLERANCE_1				0x0689
#define AD9548_REG_PROFILE_2_TOLERANCE_2				0x068A
#define AD9548_REG_PROFILE_2_TOLERANCE_3				0x068B
#define AD9548_REG_PROFILE_2_TOLERANCE_4				0x068C
#define AD9548_REG_PROFILE_2_TOLERANCE_5				0x068D
#define AD9548_REG_PROFILE_2_VALIDATION_0				0x068E
#define AD9548_REG_PROFILE_2_VALIDATION_1				0x068F
#define AD9548_REG_PROFILE_2_REDETECT_TIMEOUT_0			0x0690
#define AD9548_REG_PROFILE_2_REDETECT_TIMEOUT_1			0x0691
#define AD9548_REG_PROFILE_2_D_LOOP_FILTER_COEFF_0		0x0692
#define AD9548_REG_PROFILE_2_D_LOOP_FILTER_COEFF_1		0x0693
#define AD9548_REG_PROFILE_2_D_LOOP_FILTER_COEFF_2		0x0694
#define AD9548_REG_PROFILE_2_D_LOOP_FILTER_COEFF_3		0x0695
#define AD9548_REG_PROFILE_2_D_LOOP_FILTER_COEFF_4		0x0696
#define AD9548_REG_PROFILE_2_D_LOOP_FILTER_COEFF_5		0x0697
#define AD9548_REG_PROFILE_2_D_LOOP_FILTER_COEFF_6		0x0698
#define AD9548_REG_PROFILE_2_D_LOOP_FILTER_COEFF_7		0x0699
#define AD9548_REG_PROFILE_2_D_LOOP_FILTER_COEFF_8		0x069A
#define AD9548_REG_PROFILE_2_D_LOOP_FILTER_COEFF_9		0x069B
#define AD9548_REG_PROFILE_2_D_LOOP_FILTER_COEFF_10		0x069C
#define AD9548_REG_PROFILE_2_D_LOOP_FILTER_COEFF_11		0x069D
#define AD9548_REG_PROFILE_2_FREQ_MULTIPLICATION_0		0x069E
#define AD9548_REG_PROFILE_2_FREQ_MULTIPLICATION_1		0x069F
#define AD9548_REG_PROFILE_2_FREQ_MULTIPLICATION_2		0x06A0
#define AD9548_REG_PROFILE_2_FREQ_MULTIPLICATION_3		0x06A1
#define AD9548_REG_PROFILE_2_FREQ_MULTIPLICATION_4		0x06A2
#define AD9548_REG_PROFILE_2_FREQ_MULTIPLICATION_5		0x06A3
#define AD9548_REG_PROFILE_2_FREQ_MULTIPLICATION_6		0x06A4
#define AD9548_REG_PROFILE_2_FREQ_MULTIPLICATION_7		0x06A5
#define AD9548_REG_PROFILE_2_FREQ_MULTIPLICATION_8		0x06A6
#define AD9548_REG_PROFILE_2_FREQ_MULTIPLICATION_9		0x06A7
#define AD9548_REG_PROFILE_2_FREQ_MULTIPLICATION_10		0x06A8
#define AD9548_REG_PROFILE_2_FREQ_LOCK_DETECTORS_0		0x06A9
#define AD9548_REG_PROFILE_2_FREQ_LOCK_DETECTORS_1		0x06AA
#define AD9548_REG_PROFILE_2_FREQ_LOCK_DETECTORS_2		0x06AB
#define AD9548_REG_PROFILE_2_FREQ_LOCK_DETECTORS_3		0x06AC
#define AD9548_REG_PROFILE_2_FREQ_LOCK_DETECTORS_4		0x06AD
#define AD9548_REG_PROFILE_2_FREQ_LOCK_DETECTORS_5		0x06AE
#define AD9548_REG_PROFILE_2_FREQ_LOCK_DETECTORS_6		0x06AF
#define AD9548_REG_PROFILE_2_FREQ_LOCK_DETECTORS_7		0x06B0
#define AD9548_REG_PROFILE_2_FREQ_LOCK_DETECTORS_8		0x06B1

/* Profile 3 */
#define AD9548_REG_PROFILE_3_PRIORITIES					0x06B2
#define AD9548_REG_PROFILE_3_REFERENCE_PERIOD_0			0x06B3
#define AD9548_REG_PROFILE_3_REFERENCE_PERIOD_1			0x06B4
#define AD9548_REG_PROFILE_3_REFERENCE_PERIOD_2			0x06B5
#define AD9548_REG_PROFILE_3_REFERENCE_PERIOD_3			0x06B6
#define AD9548_REG_PROFILE_3_REFERENCE_PERIOD_4			0x06B7
#define AD9548_REG_PROFILE_3_REFERENCE_PERIOD_5			0x06B8
#define AD9548_REG_PROFILE_3_REFERENCE_PERIOD_6			0x06B9
#define AD9548_REG_PROFILE_3_TOLERANCE_0				0x06BA
#define AD9548_REG_PROFILE_3_TOLERANCE_1				0x06BB
#define AD9548_REG_PROFILE_3_TOLERANCE_2				0x06BC
#define AD9548_REG_PROFILE_3_TOLERANCE_3				0x06BD
#define AD9548_REG_PROFILE_3_TOLERANCE_4				0x06BE
#define AD9548_REG_PROFILE_3_TOLERANCE_5				0x06BF
#define AD9548_REG_PROFILE_3_VALIDATION_0				0x06C0
#define AD9548_REG_PROFILE_3_VALIDATION_1				0x06C1
#define AD9548_REG_PROFILE_3_REDETECT_TIMEOUT_0			0x06C2
#define AD9548_REG_PROFILE_3_REDETECT_TIMEOUT_1			0x06C3
#define AD9548_REG_PROFILE_3_D_LOOP_FILTER_COEFF_0		0x06C4
#define AD9548_REG_PROFILE_3_D_LOOP_FILTER_COEFF_1		0x06C5
#define AD9548_REG_PROFILE_3_D_LOOP_FILTER_COEFF_2		0x06C6
#define AD9548_REG_PROFILE_3_D_LOOP_FILTER_COEFF_3		0x06C7
#define AD9548_REG_PROFILE_3_D_LOOP_FILTER_COEFF_4		0x06C8
#define AD9548_REG_PROFILE_3_D_LOOP_FILTER_COEFF_5		0x06C9
#define AD9548_REG_PROFILE_3_D_LOOP_FILTER_COEFF_6		0x06CA
#define AD9548_REG_PROFILE_3_D_LOOP_FILTER_COEFF_7		0x06CB
#define AD9548_REG_PROFILE_3_D_LOOP_FILTER_COEFF_8		0x06CC
#define AD9548_REG_PROFILE_3_D_LOOP_FILTER_COEFF_9		0x06CD
#define AD9548_REG_PROFILE_3_D_LOOP_FILTER_COEFF_10		0x06CE
#define AD9548_REG_PROFILE_3_D_LOOP_FILTER_COEFF_11		0x06DF
#define AD9548_REG_PROFILE_3_FREQ_MULTIPLICATION_0		0x06D0
#define AD9548_REG_PROFILE_3_FREQ_MULTIPLICATION_1		0x06D1
#define AD9548_REG_PROFILE_3_FREQ_MULTIPLICATION_2		0x06D2
#define AD9548_REG_PROFILE_3_FREQ_MULTIPLICATION_3		0x06D3
#define AD9548_REG_PROFILE_3_FREQ_MULTIPLICATION_4		0x06D4
#define AD9548_REG_PROFILE_3_FREQ_MULTIPLICATION_5		0x06D5
#define AD9548_REG_PROFILE_3_FREQ_MULTIPLICATION_6		0x06D6
#define AD9548_REG_PROFILE_3_FREQ_MULTIPLICATION_7		0x06D7
#define AD9548_REG_PROFILE_3_FREQ_MULTIPLICATION_8		0x06D8
#define AD9548_REG_PROFILE_3_FREQ_MULTIPLICATION_9		0x06D9
#define AD9548_REG_PROFILE_3_FREQ_MULTIPLICATION_10		0x06DA
#define AD9548_REG_PROFILE_3_FREQ_LOCK_DETECTORS_0		0x06DB
#define AD9548_REG_PROFILE_3_FREQ_LOCK_DETECTORS_1		0x06DC
#define AD9548_REG_PROFILE_3_FREQ_LOCK_DETECTORS_2		0x06DD
#define AD9548_REG_PROFILE_3_FREQ_LOCK_DETECTORS_3		0x06DE
#define AD9548_REG_PROFILE_3_FREQ_LOCK_DETECTORS_4		0x06DF
#define AD9548_REG_PROFILE_3_FREQ_LOCK_DETECTORS_5		0x06E0
#define AD9548_REG_PROFILE_3_FREQ_LOCK_DETECTORS_6		0x06E1
#define AD9548_REG_PROFILE_3_FREQ_LOCK_DETECTORS_7		0x06E2
#define AD9548_REG_PROFILE_3_FREQ_LOCK_DETECTORS_8		0x06E3

/* Profile 4 */
#define AD9548_REG_PROFILE_4_PRIORITIES					0x0700
#define AD9548_REG_PROFILE_4_REFERENCE_PERIOD_0			0x0701
#define AD9548_REG_PROFILE_4_REFERENCE_PERIOD_1			0x0702
#define AD9548_REG_PROFILE_4_REFERENCE_PERIOD_2			0x0703
#define AD9548_REG_PROFILE_4_REFERENCE_PERIOD_3			0x0704
#define AD9548_REG_PROFILE_4_REFERENCE_PERIOD_4			0x0705
#define AD9548_REG_PROFILE_4_REFERENCE_PERIOD_5			0x0706
#define AD9548_REG_PROFILE_4_REFERENCE_PERIOD_6			0x0707
#define AD9548_REG_PROFILE_4_TOLERANCE_0				0x0708
#define AD9548_REG_PROFILE_4_TOLERANCE_1				0x0709
#define AD9548_REG_PROFILE_4_TOLERANCE_2				0x070A
#define AD9548_REG_PROFILE_4_TOLERANCE_3				0x070B
#define AD9548_REG_PROFILE_4_TOLERANCE_4				0x070C
#define AD9548_REG_PROFILE_4_TOLERANCE_5				0x070D
#define AD9548_REG_PROFILE_4_VALIDATION_0				0x070E
#define AD9548_REG_PROFILE_4_VALIDATION_1				0x070F
#define AD9548_REG_PROFILE_4_REDETECT_TIMEOUT_0			0x0710
#define AD9548_REG_PROFILE_4_REDETECT_TIMEOUT_1			0x0711
#define AD9548_REG_PROFILE_4_D_LOOP_FILTER_COEFF_0		0x0712
#define AD9548_REG_PROFILE_4_D_LOOP_FILTER_COEFF_1		0x0713
#define AD9548_REG_PROFILE_4_D_LOOP_FILTER_COEFF_2		0x0714
#define AD9548_REG_PROFILE_4_D_LOOP_FILTER_COEFF_3		0x0715
#define AD9548_REG_PROFILE_4_D_LOOP_FILTER_COEFF_4		0x0716
#define AD9548_REG_PROFILE_4_D_LOOP_FILTER_COEFF_5		0x0717
#define AD9548_REG_PROFILE_4_D_LOOP_FILTER_COEFF_6		0x0718
#define AD9548_REG_PROFILE_4_D_LOOP_FILTER_COEFF_7		0x0719
#define AD9548_REG_PROFILE_4_D_LOOP_FILTER_COEFF_8		0x071A
#define AD9548_REG_PROFILE_4_D_LOOP_FILTER_COEFF_9		0x071B
#define AD9548_REG_PROFILE_4_D_LOOP_FILTER_COEFF_10		0x071C
#define AD9548_REG_PROFILE_4_D_LOOP_FILTER_COEFF_11		0x071D
#define AD9548_REG_PROFILE_4_FREQ_MULTIPLICATION_0		0x071E
#define AD9548_REG_PROFILE_4_FREQ_MULTIPLICATION_1		0x071F
#define AD9548_REG_PROFILE_4_FREQ_MULTIPLICATION_2		0x0720
#define AD9548_REG_PROFILE_4_FREQ_MULTIPLICATION_3		0x0721
#define AD9548_REG_PROFILE_4_FREQ_MULTIPLICATION_4		0x0722
#define AD9548_REG_PROFILE_4_FREQ_MULTIPLICATION_5		0x0723
#define AD9548_REG_PROFILE_4_FREQ_MULTIPLICATION_6		0x0724
#define AD9548_REG_PROFILE_4_FREQ_MULTIPLICATION_7		0x0725
#define AD9548_REG_PROFILE_4_FREQ_MULTIPLICATION_8		0x0726
#define AD9548_REG_PROFILE_4_FREQ_MULTIPLICATION_9		0x0727
#define AD9548_REG_PROFILE_4_FREQ_MULTIPLICATION_10		0x0728
#define AD9548_REG_PROFILE_4_FREQ_LOCK_DETECTORS_0		0x0729
#define AD9548_REG_PROFILE_4_FREQ_LOCK_DETECTORS_1		0x072A
#define AD9548_REG_PROFILE_4_FREQ_LOCK_DETECTORS_2		0x072B
#define AD9548_REG_PROFILE_4_FREQ_LOCK_DETECTORS_3		0x072C
#define AD9548_REG_PROFILE_4_FREQ_LOCK_DETECTORS_4		0x072D
#define AD9548_REG_PROFILE_4_FREQ_LOCK_DETECTORS_5		0x072E
#define AD9548_REG_PROFILE_4_FREQ_LOCK_DETECTORS_6		0x072F
#define AD9548_REG_PROFILE_4_FREQ_LOCK_DETECTORS_7		0x0730
#define AD9548_REG_PROFILE_4_FREQ_LOCK_DETECTORS_8		0x0731

/* Profile 5 */
#define AD9548_REG_PROFILE_5_PRIORITIES					0x0732
#define AD9548_REG_PROFILE_5_REFERENCE_PERIOD_0			0x0733
#define AD9548_REG_PROFILE_5_REFERENCE_PERIOD_1			0x0734
#define AD9548_REG_PROFILE_5_REFERENCE_PERIOD_2			0x0735
#define AD9548_REG_PROFILE_5_REFERENCE_PERIOD_3			0x0736
#define AD9548_REG_PROFILE_5_REFERENCE_PERIOD_4			0x0737
#define AD9548_REG_PROFILE_5_REFERENCE_PERIOD_5			0x0738
#define AD9548_REG_PROFILE_5_REFERENCE_PERIOD_6			0x0739
#define AD9548_REG_PROFILE_5_TOLERANCE_0				0x073A
#define AD9548_REG_PROFILE_5_TOLERANCE_1				0x073B
#define AD9548_REG_PROFILE_5_TOLERANCE_2				0x073C
#define AD9548_REG_PROFILE_5_TOLERANCE_3				0x073D
#define AD9548_REG_PROFILE_5_TOLERANCE_4				0x073E
#define AD9548_REG_PROFILE_5_TOLERANCE_5				0x073F
#define AD9548_REG_PROFILE_5_VALIDATION_0				0x0740
#define AD9548_REG_PROFILE_5_VALIDATION_1				0x0741
#define AD9548_REG_PROFILE_5_REDETECT_TIMEOUT_0			0x0742
#define AD9548_REG_PROFILE_5_REDETECT_TIMEOUT_1			0x0743
#define AD9548_REG_PROFILE_5_D_LOOP_FILTER_COEFF_0		0x0744
#define AD9548_REG_PROFILE_5_D_LOOP_FILTER_COEFF_1		0x0745
#define AD9548_REG_PROFILE_5_D_LOOP_FILTER_COEFF_2		0x0746
#define AD9548_REG_PROFILE_5_D_LOOP_FILTER_COEFF_3		0x0747
#define AD9548_REG_PROFILE_5_D_LOOP_FILTER_COEFF_4		0x0748
#define AD9548_REG_PROFILE_5_D_LOOP_FILTER_COEFF_5		0x0749
#define AD9548_REG_PROFILE_5_D_LOOP_FILTER_COEFF_6		0x074A
#define AD9548_REG_PROFILE_5_D_LOOP_FILTER_COEFF_7		0x074B
#define AD9548_REG_PROFILE_5_D_LOOP_FILTER_COEFF_8		0x074C
#define AD9548_REG_PROFILE_5_D_LOOP_FILTER_COEFF_9		0x074D
#define AD9548_REG_PROFILE_5_D_LOOP_FILTER_COEFF_10		0x074E
#define AD9548_REG_PROFILE_5_D_LOOP_FILTER_COEFF_11		0x074F
#define AD9548_REG_PROFILE_5_FREQ_MULTIPLICATION_0		0x0750
#define AD9548_REG_PROFILE_5_FREQ_MULTIPLICATION_1		0x0751
#define AD9548_REG_PROFILE_5_FREQ_MULTIPLICATION_2		0x0752
#define AD9548_REG_PROFILE_5_FREQ_MULTIPLICATION_3		0x0753
#define AD9548_REG_PROFILE_5_FREQ_MULTIPLICATION_4		0x0754
#define AD9548_REG_PROFILE_5_FREQ_MULTIPLICATION_5		0x0755
#define AD9548_REG_PROFILE_5_FREQ_MULTIPLICATION_6		0x0756
#define AD9548_REG_PROFILE_5_FREQ_MULTIPLICATION_7		0x0757
#define AD9548_REG_PROFILE_5_FREQ_MULTIPLICATION_8		0x0758
#define AD9548_REG_PROFILE_5_FREQ_MULTIPLICATION_9		0x0759
#define AD9548_REG_PROFILE_5_FREQ_MULTIPLICATION_10		0x075A
#define AD9548_REG_PROFILE_5_FREQ_LOCK_DETECTORS_0		0x075B
#define AD9548_REG_PROFILE_5_FREQ_LOCK_DETECTORS_1		0x075C
#define AD9548_REG_PROFILE_5_FREQ_LOCK_DETECTORS_2		0x075D
#define AD9548_REG_PROFILE_5_FREQ_LOCK_DETECTORS_3		0x075E
#define AD9548_REG_PROFILE_5_FREQ_LOCK_DETECTORS_4		0x075F
#define AD9548_REG_PROFILE_5_FREQ_LOCK_DETECTORS_5		0x0760
#define AD9548_REG_PROFILE_5_FREQ_LOCK_DETECTORS_6		0x0761
#define AD9548_REG_PROFILE_5_FREQ_LOCK_DETECTORS_7		0x0762
#define AD9548_REG_PROFILE_5_FREQ_LOCK_DETECTORS_8		0x0763

/* Profile 6 */
#define AD9548_REG_PROFILE_6_PRIORITIES					0x0780
#define AD9548_REG_PROFILE_6_REFERENCE_PERIOD_0			0x0781
#define AD9548_REG_PROFILE_6_REFERENCE_PERIOD_1			0x0782
#define AD9548_REG_PROFILE_6_REFERENCE_PERIOD_2			0x0783
#define AD9548_REG_PROFILE_6_REFERENCE_PERIOD_3			0x0784
#define AD9548_REG_PROFILE_6_REFERENCE_PERIOD_4			0x0785
#define AD9548_REG_PROFILE_6_REFERENCE_PERIOD_5			0x0786
#define AD9548_REG_PROFILE_6_REFERENCE_PERIOD_6			0x0787
#define AD9548_REG_PROFILE_6_TOLERANCE_0				0x0788
#define AD9548_REG_PROFILE_6_TOLERANCE_1				0x0789
#define AD9548_REG_PROFILE_6_TOLERANCE_2				0x078A
#define AD9548_REG_PROFILE_6_TOLERANCE_3				0x078B
#define AD9548_REG_PROFILE_6_TOLERANCE_4				0x078C
#define AD9548_REG_PROFILE_6_TOLERANCE_5				0x078D
#define AD9548_REG_PROFILE_6_VALIDATION_0				0x078E
#define AD9548_REG_PROFILE_6_VALIDATION_1				0x078F
#define AD9548_REG_PROFILE_6_REDETECT_TIMEOUT_0			0x0790
#define AD9548_REG_PROFILE_6_REDETECT_TIMEOUT_1			0x0791
#define AD9548_REG_PROFILE_6_D_LOOP_FILTER_COEFF_0		0x0792
#define AD9548_REG_PROFILE_6_D_LOOP_FILTER_COEFF_1		0x0793
#define AD9548_REG_PROFILE_6_D_LOOP_FILTER_COEFF_2		0x0794
#define AD9548_REG_PROFILE_6_D_LOOP_FILTER_COEFF_3		0x0795
#define AD9548_REG_PROFILE_6_D_LOOP_FILTER_COEFF_4		0x0796
#define AD9548_REG_PROFILE_6_D_LOOP_FILTER_COEFF_5		0x0797
#define AD9548_REG_PROFILE_6_D_LOOP_FILTER_COEFF_6		0x0798
#define AD9548_REG_PROFILE_6_D_LOOP_FILTER_COEFF_7		0x0799
#define AD9548_REG_PROFILE_6_D_LOOP_FILTER_COEFF_8		0x079A
#define AD9548_REG_PROFILE_6_D_LOOP_FILTER_COEFF_9		0x079B
#define AD9548_REG_PROFILE_6_D_LOOP_FILTER_COEFF_10		0x079C
#define AD9548_REG_PROFILE_6_D_LOOP_FILTER_COEFF_11		0x079D
#define AD9548_REG_PROFILE_6_FREQ_MULTIPLICATION_0		0x079E
#define AD9548_REG_PROFILE_6_FREQ_MULTIPLICATION_1		0x079F
#define AD9548_REG_PROFILE_6_FREQ_MULTIPLICATION_2		0x07A0
#define AD9548_REG_PROFILE_6_FREQ_MULTIPLICATION_3		0x07A1
#define AD9548_REG_PROFILE_6_FREQ_MULTIPLICATION_4		0x07A2
#define AD9548_REG_PROFILE_6_FREQ_MULTIPLICATION_5		0x07A3
#define AD9548_REG_PROFILE_6_FREQ_MULTIPLICATION_6		0x07A4
#define AD9548_REG_PROFILE_6_FREQ_MULTIPLICATION_7		0x07A5
#define AD9548_REG_PROFILE_6_FREQ_MULTIPLICATION_8		0x07A6
#define AD9548_REG_PROFILE_6_FREQ_MULTIPLICATION_9		0x07A7
#define AD9548_REG_PROFILE_6_FREQ_MULTIPLICATION_10		0x07A8
#define AD9548_REG_PROFILE_6_FREQ_LOCK_DETECTORS_0		0x07A9
#define AD9548_REG_PROFILE_6_FREQ_LOCK_DETECTORS_1		0x07AA
#define AD9548_REG_PROFILE_6_FREQ_LOCK_DETECTORS_2		0x07AB
#define AD9548_REG_PROFILE_6_FREQ_LOCK_DETECTORS_3		0x07AC
#define AD9548_REG_PROFILE_6_FREQ_LOCK_DETECTORS_4		0x07AD
#define AD9548_REG_PROFILE_6_FREQ_LOCK_DETECTORS_5		0x07AE
#define AD9548_REG_PROFILE_6_FREQ_LOCK_DETECTORS_6		0x07AF
#define AD9548_REG_PROFILE_6_FREQ_LOCK_DETECTORS_7		0x07B0
#define AD9548_REG_PROFILE_6_FREQ_LOCK_DETECTORS_8		0x07B1

/* Profile 7 */
#define AD9548_REG_PROFILE_7_PRIORITIES					0x07B2
#define AD9548_REG_PROFILE_7_REFERENCE_PERIOD_0			0x07B3
#define AD9548_REG_PROFILE_7_REFERENCE_PERIOD_1			0x07B4
#define AD9548_REG_PROFILE_7_REFERENCE_PERIOD_2			0x07B5
#define AD9548_REG_PROFILE_7_REFERENCE_PERIOD_3			0x07B6
#define AD9548_REG_PROFILE_7_REFERENCE_PERIOD_4			0x07B7
#define AD9548_REG_PROFILE_7_REFERENCE_PERIOD_5			0x07B8
#define AD9548_REG_PROFILE_7_REFERENCE_PERIOD_6			0x07B9
#define AD9548_REG_PROFILE_7_TOLERANCE_0				0x07BA
#define AD9548_REG_PROFILE_7_TOLERANCE_1				0x07BB
#define AD9548_REG_PROFILE_7_TOLERANCE_2				0x07BC
#define AD9548_REG_PROFILE_7_TOLERANCE_3				0x07BD
#define AD9548_REG_PROFILE_7_TOLERANCE_4				0x07BE
#define AD9548_REG_PROFILE_7_TOLERANCE_5				0x07BF
#define AD9548_REG_PROFILE_7_VALIDATION_0				0x07C0
#define AD9548_REG_PROFILE_7_VALIDATION_1				0x07C1
#define AD9548_REG_PROFILE_7_REDETECT_TIMEOUT_0			0x07C2
#define AD9548_REG_PROFILE_7_REDETECT_TIMEOUT_1			0x07C3
#define AD9548_REG_PROFILE_7_D_LOOP_FILTER_COEFF_0		0x07C4
#define AD9548_REG_PROFILE_7_D_LOOP_FILTER_COEFF_1		0x07C5
#define AD9548_REG_PROFILE_7_D_LOOP_FILTER_COEFF_2		0x07C6
#define AD9548_REG_PROFILE_7_D_LOOP_FILTER_COEFF_3		0x07C7
#define AD9548_REG_PROFILE_7_D_LOOP_FILTER_COEFF_4		0x07C8
#define AD9548_REG_PROFILE_7_D_LOOP_FILTER_COEFF_5		0x07C9
#define AD9548_REG_PROFILE_7_D_LOOP_FILTER_COEFF_6		0x07CA
#define AD9548_REG_PROFILE_7_D_LOOP_FILTER_COEFF_7		0x07CB
#define AD9548_REG_PROFILE_7_D_LOOP_FILTER_COEFF_8		0x07CC
#define AD9548_REG_PROFILE_7_D_LOOP_FILTER_COEFF_9		0x07CD
#define AD9548_REG_PROFILE_7_D_LOOP_FILTER_COEFF_10		0x07CE
#define AD9548_REG_PROFILE_7_D_LOOP_FILTER_COEFF_11		0x07DF
#define AD9548_REG_PROFILE_7_FREQ_MULTIPLICATION_0		0x07D0
#define AD9548_REG_PROFILE_7_FREQ_MULTIPLICATION_1		0x07D1
#define AD9548_REG_PROFILE_7_FREQ_MULTIPLICATION_2		0x07D2
#define AD9548_REG_PROFILE_7_FREQ_MULTIPLICATION_3		0x07D3
#define AD9548_REG_PROFILE_7_FREQ_MULTIPLICATION_4		0x07D4
#define AD9548_REG_PROFILE_7_FREQ_MULTIPLICATION_5		0x07D5
#define AD9548_REG_PROFILE_7_FREQ_MULTIPLICATION_6		0x07D6
#define AD9548_REG_PROFILE_7_FREQ_MULTIPLICATION_7		0x07D7
#define AD9548_REG_PROFILE_7_FREQ_MULTIPLICATION_8		0x07D8
#define AD9548_REG_PROFILE_7_FREQ_MULTIPLICATION_9		0x07D9
#define AD9548_REG_PROFILE_7_FREQ_MULTIPLICATION_10		0x07DA
#define AD9548_REG_PROFILE_7_FREQ_LOCK_DETECTORS_0		0x07DB
#define AD9548_REG_PROFILE_7_FREQ_LOCK_DETECTORS_1		0x07DC
#define AD9548_REG_PROFILE_7_FREQ_LOCK_DETECTORS_2		0x07DD
#define AD9548_REG_PROFILE_7_FREQ_LOCK_DETECTORS_3		0x07DE
#define AD9548_REG_PROFILE_7_FREQ_LOCK_DETECTORS_4		0x07DF
#define AD9548_REG_PROFILE_7_FREQ_LOCK_DETECTORS_5		0x07E0
#define AD9548_REG_PROFILE_7_FREQ_LOCK_DETECTORS_6		0x07E1
#define AD9548_REG_PROFILE_7_FREQ_LOCK_DETECTORS_7		0x07E2
#define AD9548_REG_PROFILE_7_FREQ_LOCK_DETECTORS_8		0x07E3

/* Operational controls */
#define AD9548_REG_GENERAL_POWER_DOWN					0x0A00
#define AD9548_REG_LOOP_MODE							0x0A01
#define AD9548_REG_CAL_SYNC								0x0A02
#define AD9548_REG_RESET_FUNC							0x0A03
#define AD9548_REG_IRQ_CLEARING_0						0x0A04
#define AD9548_REG_IRQ_CLEARING_1						0x0A05
#define AD9548_REG_IRQ_CLEARING_2						0x0A06
#define AD9548_REG_IRQ_CLEARING_3						0x0A07
#define AD9548_REG_IRQ_CLEARING_4						0x0A08
#define AD9548_REG_IRQ_CLEARING_5						0x0A09
#define AD9548_REG_IRQ_CLEARING_6						0x0A0A
#define AD9548_REG_IRQ_CLEARING_7						0x0A0B
#define AD9548_REG_INCREMENTAL_PHA_OFFSET				0x0A0C
#define AD9548_REG_REFERENCE_PROFILE_DETECT				0x0A0D
#define AD9548_REG_FORCE_VALIDATION_TIMEOUT				0x0A0E
#define AD9548_REG_REFERENCE_MONITOR_OVERRIDE			0x0A0F
#define AD9548_REG_REFERENCE_MONITOR_BYPASS				0x0A10

/* Status (read only; accessible during EEPROM transactions) */
#define AD9548_REG_EEPROM								0x0D00
#define AD9548_REG_SYSTEM_CLOCK							0x0D01
#define AD9548_REG_IRQ_MONITOR_0						0x0D02
#define AD9548_REG_IRQ_MONITOR_1						0x0D03
#define AD9548_REG_IRQ_MONITOR_2						0x0D04
#define AD9548_REG_IRQ_MONITOR_3						0x0D05
#define AD9548_REG_IRQ_MONITOR_4						0x0D06
#define AD9548_REG_IRQ_MONITOR_5						0x0D07
#define AD9548_REG_IRQ_MONITOR_6						0x0D08
#define AD9548_REG_IRQ_MONITOR_7						0x0D09
#define AD9548_REG_DLL_STATUS_0							0x0D0A
#define AD9548_REG_DLL_STATUS_1							0x0D0B
#define AD9548_REG_REF_A								0x0D0C
#define AD9548_REG_REF_AA								0x0D0D
#define AD9548_REG_REF_B								0x0D0E
#define AD9548_REG_REF_BB								0x0D0F
#define AD9548_REG_REF_C								0x0D10
#define AD9548_REG_REF_CC								0x0D11
#define AD9548_REG_REF_D								0x0D12
#define AD9548_REG_REF_DD								0x0D13
#define AD9548_REG_HOLDOVER_HISTORY_0					0x0D14
#define AD9548_REG_HOLDOVER_HISTORY_1					0x0D15
#define AD9548_REG_HOLDOVER_HISTORY_2					0x0D16
#define AD9548_REG_HOLDOVER_HISTORY_3					0x0D17
#define AD9548_REG_HOLDOVER_HISTORY_4					0x0D18
#define AD9548_REG_HOLDOVER_HISTORY_5					0x0D19

/* Nonvolatile memory (EEPROM) control */
#define AD9548_REG_WRITE_PROTECT						0x0E00
#define AD9548_REG_CONDITION							0x0E01
#define AD9548_REG_SAVE									0x0E02
#define AD9548_REG_LOAD									0x0E03

/* EEPROM storage sequence */
#define AD9548_REG_SYSTEM_CLOCK_0						0x0E10
#define AD9548_REG_SYSTEM_CLOCK_1						0x0E11
#define AD9548_REG_SYSTEM_CLOCK_2						0x0E12
#define AD9548_REG_IO_UPDATE_0							0x0E13
#define AD9548_REG_SYSCLK_CALIBRATE						0x0E14
#define AD9548_REG_GENERAL_0							0x0E15
#define AD9548_REG_GENERAL_1							0x0E16
#define AD9548_REG_GENERAL_2							0x0E17
#define AD9548_REG_DPLL_0								0x0E18
#define AD9548_REG_DPLL_1								0x0E19
#define AD9548_REG_DPLL_2								0x0E1A
#define AD9548_REG_CLOCK_DISTRIBUTION_0					0x0E1B
#define AD9548_REG_CLOCK_DISTRIBUTION_1					0x0E1C
#define AD9548_REG_CLOCK_DISTRIBUTION_2					0x0E1D
#define AD9548_REG_IO_UPDATE_1							0x0E1E
#define AD9548_REG_REFERENCE_INPUTS_0					0x0E1F
#define AD9548_REG_REFERENCE_INPUTS_1					0x0E20
#define AD9548_REG_REFERENCE_INPUTS_2					0x0E21
#define AD9548_REG_PROFILE_0_PROFILE_1_0				0x0E22
#define AD9548_REG_PROFILE_0_PROFILE_1_1				0x0E23
#define AD9548_REG_PROFILE_0_PROFILE_1_2				0x0E24
#define AD9548_REG_PROFILE_2_PROFILE_3_0				0x0E25
#define AD9548_REG_PROFILE_2_PROFILE_3_1				0x0E26
#define AD9548_REG_PROFILE_2_PROFILE_3_2				0x0E27
#define AD9548_REG_PROFILE_4_PROFILE_5_0				0x0E28
#define AD9548_REG_PROFILE_4_PROFILE_5_1				0x0E29
#define AD9548_REG_PROFILE_4_PROFILE_5_2				0x0E2A
#define AD9548_REG_PROFILE_6_PROFILE_7_0				0x0E2B
#define AD9548_REG_PROFILE_6_PROFILE_7_1				0x0E2C
#define AD9548_REG_PROFILE_6_PROFILE_7_2				0x0E2D
#define AD9548_REG_IO_UPDATE_2							0x0E2E
#define AD9548_REG_OPERATIONAL_CONTROLS_0				0x0E2F
#define AD9548_REG_OPERATIONAL_CONTROLS_1				0x0E30
#define AD9548_REG_OPERATIONAL_CONTROLS_2				0x0E31
#define AD9548_REG_IO_UPDATE_3							0x0E32
#define AD9548_REG_END_OF_DATA							0x0E33
#define AD9548_REG_SCRATH_PAD_AREA_0					0x0E34
#define AD9548_REG_SCRATH_PAD_AREA_1					0x0E35
#define AD9548_REG_SCRATH_PAD_AREA_2					0x0E36
#define AD9548_REG_SCRATH_PAD_AREA_3					0x0E37
#define AD9548_REG_SCRATH_PAD_AREA_4					0x0E38
#define AD9548_REG_SCRATH_PAD_AREA_5					0x0E39
#define AD9548_REG_SCRATH_PAD_AREA_6					0x0E3A
#define AD9548_REG_SCRATH_PAD_AREA_7					0x0E3B
#define AD9548_REG_SCRATH_PAD_AREA_8					0x0E3C
#define AD9548_REG_SCRATH_PAD_AREA_9					0x0E3D
#define AD9548_REG_SCRATH_PAD_AREA_10					0x0E3E
#define AD9548_REG_SCRATH_PAD_AREA_11					0x0E3F

/******************************************************************************/
/************************ Types Definitions ***********************************/
/******************************************************************************/
struct ad9548_reference_profile
{
    uint8_t phase_lock_scale;
    uint8_t promoted_priority;
    uint8_t selection_priority;
    uint8_t reference_period;
    uint8_t nom_reference_period;
    uint16_t inner_tolerance;
    uint16_t outer_tolerance;
    uint16_t validation_timer;
    uint16_t redetect_timer;
    uint16_t dpll_alpha0_linear;
    uint16_t dpll_alpha1_exp;
    uint16_t dpll_alpha2_exp;
    uint16_t dpll_alpha3_exp;
    uint16_t dpll_beta0_linear;
    uint16_t dpll_beta1_exp;
    uint16_t dpll_gamma0_linear;
    uint16_t dpll_gamma1_exp;
    uint16_t dpll_delta0_linear;
    uint16_t dpll_delta1_exp;
    uint32_t r_div;
    uint32_t s_div;
    uint32_t u_div;
    uint32_t v_div;
    uint16_t phase_lock_threshold;
    uint16_t phase_lock_fill_rate;
    uint16_t phase_lock_drain_rate;
    uint16_t freq_lock_threshold;
    uint16_t freq_lock_fill_rate;
    uint16_t freq_lock_drain_rate;
};

struct ad9548_reference_spec 
{
    uint8_t ref_num;
    uint32_t ref_freq;
    uint8_t power_down_en;
    uint8_t logic_family;
    uint8_t manual_profile_en;
    uint8_t manual_profile;
};

struct ad9548_channel_spec 
{
    uint32_t channel_num;
    uint32_t channel_divider;
    uint8_t output_dis;
    uint8_t low_power_mode_en;
    uint8_t low_power_sync_en;
    uint8_t driver_mode;
    uint8_t cmos_mode_phase_invert;
    uint8_t polarity_invert_en;
    uint8_t drive_strength;
    uint8_t sync_ignore_en;
    int8_t extended_name[16];
};

struct ad9548_platform_data 
{
    /* System clock settings */
    uint8_t sys_clk_ext_loop_filter_en;
    uint8_t sys_clk_charge_pump_manual_mode_en;
    uint8_t sys_clk_pll_lock_detect_timer_dis;
    uint8_t sys_clk_charge_pump_current;
    uint8_t sys_clk_pll_lock_detect_timer;
    uint8_t sys_clk_fedback_div;
    uint8_t sys_clk_m_div;
    uint8_t sys_clk_2x_mul_en;
    uint8_t sys_clk_pll_en;
    uint8_t sys_clk_source;
    uint32_t sys_clk_period;
    uint32_t sys_clk_stability;
    
    /* DPLL Setting */
    uint8_t dpll_tunning_word0;
    uint8_t dpll_tunning_word1;
    uint8_t dpll_tunning_word2; 
    uint8_t dpll_tunning_word3; 
    uint8_t dpll_tunning_word4; 
    uint8_t dpll_tunning_word5;
    uint32_t dpll_pull_in_range_limit_low;
    uint32_t dpll_pull_in_range_limit_high;
    uint32_t dpll_dds_phase_offset;
    uint32_t dpll_closed_loop_phase_lock_offset_low;
    uint32_t dpll_closed_loop_phase_lock_offset_high;
    uint32_t dpll_incremental_phase_lock_offset;
    uint32_t dpll_phase_slew_limit;
    uint32_t dpll_history_acc_timer;
    uint16_t dpll_history_mode;
    uint32_t dpll_out_freq;

    /* Clock distribution synchronization */
    uint8_t clock_distr_ext_resistor;
    uint8_t clock_distr_high_freq_mode;
    uint16_t clock_distr_sync_source;
    uint16_t clock_distr_automatic_sync_mode;
   
    /* General settings */    
    uint16_t watchdog_timer;
    uint16_t aux_dac_full_scale_current;
    uint8_t aux_dac_shutdown;
    uint8_t ref_profile_sel_ssm_startup;

    /* Output Channel Configuration */
    int32_t num_channels;
    struct ad9548_channel_spec *channels;

    /* Reference inputs */
    int32_t num_references;
    struct ad9548_reference_spec *references;

    /* Reference profiles */
    int num_ref_profiles;
    struct ad9548_reference_profile *ref_profiles; 

    int8_t name[32];
};

#define ARRAY_SIZE(ar) (sizeof(ar)/sizeof(ar[0]))

/******************************************************************************/
/************************ Functions Declarations ******************************/
/******************************************************************************/

/** Initializes the AD9548. Returns negative error code or 0 in case of success. */
int32_t ad9548_setup();
/** Resets the device. */
int32_t ad9548_reset();
/** Sets the output frequency for output channel 1.*/
int64_t ad9548_out_altvoltage0_frequency(int64_t Hz);
/** Sets the output frequency for output channel 2. */
int64_t ad9548_out_altvoltage1_frequency(int64_t Hz);
/** Sets the output frequency for output channel 2. */
int64_t ad9548_out_altvoltage2_frequency(int64_t Hz);
/**  Sets the output frequency for output channel 3.*/
int64_t ad9548_out_altvoltage3_frequency(int64_t Hz);
/** Triggers the clock distribution synchronization functionality. */
int32_t ad9548_sync_dividers(); 
/** Triggers system clock calibration. */
int32_t ad9548_calibrate_sys_clk(); 
/** Reset internal hardware but retain programmed register values */
int32_t ad9548_reset_sans_reg_map(int32_t en);
/**  Sets the SYS CLK power mode*/
int32_t ad9548_sys_clk_pwd(int32_t en);
/**  Sets the reference power mode*/
int32_t ad9548_reference_pwd(int32_t en);
/**  Sets the TDC power mode*/
int32_t ad9548_tdc_pwd(int32_t en);
/**  Sets the DAC power mode*/
int32_t ad9548_dac_pwd(int32_t en);
/**  Sets the distribution power mode*/
int32_t ad9548_dist_pwd(int32_t en);
/**  Sets the full power mode*/
int32_t ad9548_full_pwd(int32_t en);
/** Returns the stability status of the SYS CLK */
int32_t ad9548_sys_clk_stable();
/** Returns the PLL lock status */
int32_t ad9548_sys_clk_pll_locked();
/** Returns the DPLL phase lock status */
int32_t ad9548_dpll_phase_locked();
/** Returns the DPLL frequency lock status */
int32_t ad9548_dpll_frequency_locked();
/** Returns the REFA state */
int32_t ad9548_refa_state();
/** Returns the REFAA state */
int32_t ad9548_refaa_state();
/** Returns the REFB state */
int32_t ad9548_refb_state();
/** Returns the REFBB state */
int32_t ad9548_refbb_state();
/** Returns the REFC state */
int32_t ad9548_refc_state();
/** Returns the REFCC state */
int32_t ad9548_refcc_state();
/** Returns the REFD state */
int32_t ad9548_refd_state();
/** Returns the REFDD state */
int32_t ad9548_refdd_state();

#endif // __AD9548_H__
