-module(s1ap_proxy_test).

-include_lib("eunit/include/eunit.hrl").

-define(EXP_ADDR_STR, "127.0.0.1").
-define(EXP_ADDR_BIN, << 16#7f, 16#00, 16#00, 16#01 >>).

%% ------------------------------------------------------------------
%% testcases
%% ------------------------------------------------------------------

%% S1 SETUP REQUEST
s1_setup_req_pdu() ->
    << 16#00, 16#11, 16#00, 16#1a, 16#00, 16#00, 16#02, 16#00,
       16#3b, 16#40, 16#08, 16#00, 16#00, 16#f1, 16#10, 16#00,
       16#00, 16#00, 16#00, 16#00, 16#40, 16#00, 16#07, 16#00,
       16#0c, 16#0e, 16#40, 16#00, 16#f1, 16#10
    >>.

s1_setup_req_test() ->
    OrigData = s1_setup_req_pdu(),
    %% Expect the PDU to be proxied unmodified
    ?assertEqual(OrigData, s1ap_proxy:handle_pdu(OrigData)).


%% [eNB -> MME] E-RAB SETUP REQUEST
e_rab_setup_req_pdu(TLA, TEID) when is_binary(TLA),
                                    is_binary(TEID) ->
    << 16#00, 16#05, 16#00, 16#80, 16#9b, 16#00, 16#00, 16#03,
       16#00, 16#00, 16#00, 16#02, 16#00, 16#07, 16#00, 16#08,
       16#00, 16#02, 16#00, 16#09, 16#00, 16#10, 16#00, 16#80,
       16#87, 16#00, 16#00, 16#11, 16#00, 16#80, 16#81, 16#0c,
       16#00, 16#05, 16#04, 16#0f, 16#80,
       TLA/bytes, %% transportLayerAddress (IPv4)
       TEID/bytes, %% GTP-TEID
       16#72, 16#27, 16#c8,
       16#1a, 16#bc, 16#ec, 16#11, 16#62, 16#54, 16#c1, 16#01,
       16#05, 16#04, 16#03, 16#69, 16#6d, 16#73, 16#05, 16#01,
       16#c0, 16#a8, 16#65, 16#02, 16#5e, 16#02, 16#b3, 16#8c,
       16#58, 16#32, 16#27, 16#54, 16#80, 16#80, 16#21, 16#10,
       16#02, 16#00, 16#00, 16#10, 16#81, 16#06, 16#08, 16#08,
       16#08, 16#08, 16#83, 16#06, 16#08, 16#08, 16#04, 16#04,
       16#00, 16#0d, 16#04, 16#08, 16#08, 16#08, 16#08, 16#00,
       16#0d, 16#04, 16#08, 16#08, 16#04, 16#04, 16#00, 16#03,
       16#10, 16#20, 16#01, 16#48, 16#60, 16#48, 16#60, 16#00,
       16#00, 16#00, 16#00, 16#00, 16#00, 16#00, 16#00, 16#88,
       16#88, 16#00, 16#03, 16#10, 16#20, 16#01, 16#48, 16#60,
       16#48, 16#60, 16#00, 16#00, 16#00, 16#00, 16#00, 16#00,
       16#00, 16#00, 16#88, 16#44, 16#00, 16#0c, 16#04, 16#ac,
       16#16, 16#00, 16#15, 16#00, 16#10, 16#02, 16#05, 16#78
    >>.

e_rab_setup_req_test() ->
    %% Original input data
    TEID = << 16#00, 16#00, 16#00, 16#18 >>,
    OrigTLA = << 16#ac, 16#16, 16#00, 16#06 >>,
    OrigData = e_rab_setup_req_pdu(OrigTLA, TEID),

    %% Expected output data
    ExpData = e_rab_setup_req_pdu(?EXP_ADDR_BIN, TEID),

    application:set_env(osmo_s1gw, mme_loc_addr, ?EXP_ADDR_STR),
    ?assertEqual(ExpData, s1ap_proxy:handle_pdu(OrigData)).


%% [MME -> eNB] E-RAB SETUP RESPONSE
e_rab_setup_rsp_pdu(TLA, TEID) when is_binary(TLA),
                                    is_binary(TEID) ->
    << 16#20, 16#05, 16#00, 16#22, 16#00, 16#00, 16#03, 16#00,
       16#00, 16#40, 16#02, 16#00, 16#07, 16#00, 16#08, 16#40,
       16#02, 16#00, 16#09, 16#00, 16#1c, 16#40, 16#0f, 16#00,
       16#00, 16#27, 16#40, 16#0a, 16#0c, 16#1f,
       TLA/bytes, %% transportLayerAddress (IPv4)
       TEID/bytes %% GTP-TEID
    >>.

e_rab_setup_rsp_test() ->
    %% Original input data
    TEID = << 16#6c, 16#05, 16#bf, 16#56 >>,
    OrigTLA = << 16#c0, 16#a8, 16#68, 16#a7 >>,
    OrigData = e_rab_setup_rsp_pdu(OrigTLA, TEID),

    %% Expected output data
    ExpData = e_rab_setup_rsp_pdu(?EXP_ADDR_BIN, TEID),

    application:set_env(osmo_s1gw, s1gw_bind_addr, ?EXP_ADDR_STR),
    ?assertEqual(ExpData, s1ap_proxy:handle_pdu(OrigData)).


%% [eNB -> MME] E-RAB MODIFICATION INDICATION
e_rab_modify_ind_pdu(TLA, TEID) when is_binary(TLA),
                                     is_binary(TEID) ->
    << 16#00, 16#32, 16#00, 16#24, 16#00, 16#00, 16#03, 16#00,
       16#00, 16#00, 16#02, 16#00, 16#02, 16#00, 16#08, 16#00,
       16#04, 16#80, 16#06, 16#69, 16#2d, 16#00, 16#c7, 16#00,
       16#0f, 16#00, 16#00, 16#c8, 16#00, 16#0a, 16#0a, 16#1f,
       TLA/bytes, %% transportLayerAddress (IPv4)
       TEID/bytes %% GTP-TEID
    >>.

e_rab_modify_ind_test() ->
    %% Original input data
    TEID = << 16#3d, 16#b0, 16#b5, 16#1d >>,
    OrigTLA = << 16#c0, 16#a8, 16#12, 16#c6 >>,
    OrigData = e_rab_modify_ind_pdu(OrigTLA, TEID),

    %% Expected output data
    ExpData = e_rab_modify_ind_pdu(?EXP_ADDR_BIN, TEID),

    application:set_env(osmo_s1gw, mme_loc_addr, ?EXP_ADDR_STR),
    ?assertEqual(ExpData, s1ap_proxy:handle_pdu(OrigData)).


%% [eNB -> MME] INITIAL CONTEXT SETUP REQUEST
initial_context_setup_req_pdu(TLA, TEID) when is_binary(TLA),
                                              is_binary(TEID) ->
    << 16#00, 16#09, 16#00, 16#81, 16#10, 16#00, 16#00, 16#07,
       16#00, 16#00, 16#00, 16#02, 16#00, 16#01, 16#00, 16#08,
       16#00, 16#02, 16#00, 16#01, 16#00, 16#42, 16#00, 16#0a,
       16#18, 16#3b, 16#9a, 16#ca, 16#00, 16#60, 16#3b, 16#9a,
       16#ca, 16#00, 16#00, 16#18, 16#00, 16#80, 16#b5, 16#00,
       16#00, 16#34, 16#00, 16#80, 16#af, 16#45, 16#00, 16#09,
       16#20, 16#0f, 16#80,
       TLA/bytes, %% transportLayerAddress (IPv4)
       TEID/bytes, %% GTP-TEID
       16#80, 16#9f, 16#27, 16#bd, 16#de,
       16#61, 16#4e, 16#02, 16#07, 16#42, 16#02, 16#29, 16#06,
       16#40, 16#32, 16#f8, 16#10, 16#00, 16#01, 16#00, 16#6e,
       16#52, 16#05, 16#c1, 16#01, 16#09, 16#09, 16#08, 16#69,
       16#6e, 16#74, 16#65, 16#72, 16#6e, 16#65, 16#74, 16#05,
       16#01, 16#c0, 16#a8, 16#64, 16#02, 16#5e, 16#06, 16#fe,
       16#fe, 16#fa, 16#fa, 16#02, 16#02, 16#58, 16#32, 16#27,
       16#4d, 16#80, 16#80, 16#21, 16#10, 16#02, 16#00, 16#00,
       16#10, 16#81, 16#06, 16#08, 16#08, 16#08, 16#08, 16#83,
       16#06, 16#08, 16#08, 16#04, 16#04, 16#00, 16#0d, 16#04,
       16#08, 16#08, 16#08, 16#08, 16#00, 16#0d, 16#04, 16#08,
       16#08, 16#04, 16#04, 16#00, 16#03, 16#10, 16#20, 16#01,
       16#48, 16#60, 16#48, 16#60, 16#00, 16#00, 16#00, 16#00,
       16#00, 16#00, 16#00, 16#00, 16#88, 16#88, 16#00, 16#03,
       16#10, 16#20, 16#01, 16#48, 16#60, 16#48, 16#60, 16#00,
       16#00, 16#00, 16#00, 16#00, 16#00, 16#00, 16#00, 16#88,
       16#44, 16#00, 16#10, 16#02, 16#05, 16#aa, 16#50, 16#0b,
       16#f6, 16#32, 16#f8, 16#10, 16#00, 16#02, 16#01, 16#c0,
       16#00, 16#02, 16#86, 16#13, 16#32, 16#f8, 16#10, 16#00,
       16#01, 16#23, 16#05, 16#f4, 16#04, 16#94, 16#25, 16#f8,
       16#64, 16#02, 16#01, 16#08, 16#00, 16#6b, 16#00, 16#05,
       16#1c, 16#00, 16#0e, 16#00, 16#00, 16#00, 16#49, 16#00,
       16#20, 16#57, 16#5d, 16#d3, 16#66, 16#69, 16#73, 16#4c,
       16#8c, 16#48, 16#42, 16#76, 16#5f, 16#fe, 16#f9, 16#bd,
       16#d5, 16#89, 16#08, 16#ae, 16#f6, 16#f4, 16#88, 16#62,
       16#22, 16#d7, 16#80, 16#fb, 16#36, 16#33, 16#d9, 16#9e,
       16#9f, 16#00, 16#c0, 16#40, 16#08, 16#35, 16#87, 16#61,
       16#10, 16#03, 16#ff, 16#ff, 16#74
    >>.

initial_context_setup_req_test() ->
    %% Original input data
    TEID = << 16#00, 16#00, 16#71, 16#23 >>,
    OrigTLA = << 16#c0, 16#a8, 16#02, 16#d2 >>,
    OrigData = initial_context_setup_req_pdu(OrigTLA, TEID),

    %% Expected output data
    ExpData = initial_context_setup_req_pdu(?EXP_ADDR_BIN, TEID),

    application:set_env(osmo_s1gw, mme_loc_addr, ?EXP_ADDR_STR),
    ?assertEqual(ExpData, s1ap_proxy:handle_pdu(OrigData)).


%% [MME -> eNB] INITIAL CONTEXT SETUP RESPONSE
initial_context_setup_rsp_pdu(TLA, TEID) when is_binary(TLA),
                                              is_binary(TEID) ->
    << 16#20, 16#09, 16#00, 16#22, 16#00, 16#00, 16#03, 16#00,
       16#00, 16#40, 16#02, 16#00, 16#01, 16#00, 16#08, 16#40,
       16#02, 16#00, 16#01, 16#00, 16#33, 16#40, 16#0f, 16#00,
       16#00, 16#32, 16#40, 16#0a, 16#0a, 16#1f,
       TLA/bytes, %% transportLayerAddress (IPv4)
       TEID/bytes %% GTP-TEID
    >>.

initial_context_setup_rsp_test() ->
    %% Original input data
    TEID = << 16#00, 16#00, 16#00, 16#01 >>,
    OrigTLA = << 16#c0, 16#a8, 16#02, 16#cb >>,
    OrigData = initial_context_setup_rsp_pdu(OrigTLA, TEID),

    %% Expected output data
    ExpData = initial_context_setup_rsp_pdu(?EXP_ADDR_BIN, TEID),

    application:set_env(osmo_s1gw, s1gw_bind_addr, ?EXP_ADDR_STR),
    ?assertEqual(ExpData, s1ap_proxy:handle_pdu(OrigData)).

%% vim:set ts=4 sw=4 et:
