---
title: "v0.5.1 - SMS over SG Supported"
date: 2019-07-30 22:20:00 +0900
categories:
  - Release
tags:
  - News
  - Release
head_inline: "<style> ul { padding-bottom: 1em; } </style>"
---

#### New Features
- SMS over SG Support

#### Solving the CS Fallback Issue
- CS Fallback Configuration Changes ([#224](https://github.com/open5gs/open5gs/issues/224), [#225](https://github.com/open5gs/open5gs/issues/225), [#231](https://github.com/open5gs/open5gs/issues/231)) -- [medeiros405](https://github.com/medeiros405)

1. Single MSC/VLR(127.0.0.2)
```
   sgsap:
     addr: 127.0.0.2
     map:
       tai:
         plmn_id:
           mcc: 001
           mnc: 01
         tac: 4130
       lai:
         plmn_id:
           mcc: 001
           mnc: 01
         lac: 43690
     map:
       tai:
         plmn_id:
           mcc: 002
           mnc: 02
         tac: 4132
       lai:
         plmn_id:
           mcc: 002
           mnc: 02
         lac: 43692
```         

2. Multiple MSC/VLR

```         
   sgsap:
     - addr: 127.0.0.2
       port: 29119
       map:
         tai:
           plmn_id:
             mcc: 001
             mnc: 01
           tac: 4131
         lai:
           plmn_id:
             mcc: 001
             mnc: 01
           lac: 43691
       map:
         tai:
           plmn_id:
             mcc: 002
             mnc: 02
           tac: 4132
         lai:
           plmn_id:
             mcc: 002
             mnc: 02
           lac: 43692
     - addr
        - 127.0.0.3
        - fe80::2%lo
       map:
         tai:
           plmn_id:
             mcc: 001
             mnc: 01
           tac: 4132
         lai:
           plmn_id:
             mcc: 002
             mnc: 02
           lac: 43692
     - name: msc.open5gs.org
       map:
         tai:
           plmn_id:
             mcc: 001
             mnc: 01
           tac: 4133
         lai:
           plmn_id:
             mcc: 002
             mnc: 02
           lac: 43693
```

- UEContextModifcationRequest does not have both CSFallbackIndicator and SecurityCapabilities ([#223](https://github.com/open5gs/open5gs/pull/223)) -- [medeiros405](https://github.com/medeiros405)
- Open5GS crash in MT-Fallback with fixing the BUG of ogs_realloc() ([ogslib:#4](https://github.com/open5gs/ogslib/issues/4))
- Add Paging Reject

#### Enhancements
- Fix Diameter spec-compliant related issue ([#240](https://github.com/open5gs/open5gs/pull/240)) -- [laf0rge](https://github.com/laf0rge)
- Prefer to use SCTP in Diameter ([#235](https://github.com/open5gs/open5gs/pull/235)) -- [laf0rge](https://github.com/laf0rge)
- Set Diameter SCTP PPID to 46 ([#234](https://github.com/open5gs/open5gs/issues/234)) -- [laf0rge](https://github.com/laf0rge)
- MME protects SecurityModeComplete that is not integrity ([#226](https://github.com/open5gs/open5gs/issues/226)) -- [laf0rge](https://github.com/laf0rge)
- Add Guard timer in EMM state machine ([#220](https://github.com/open5gs/open5gs/pull/220)) -- [laf0rge](https://github.com/laf0rge)
- mme-kdf: Ensure input arguments(kasme, ..) are read-only and 'const' ([#230](https://github.com/open5gs/open5gs/pull/230)) -- [laf0rge](https://github.com/laf0rge)


#### Bug fixes
- Fix the problem of releasing Dedicated Bearer ([#180](https://github.com/open5gs/open5gs/issues/180)) -- [lezixiao](https://github.com/lezixiao)
- Fix the MME crash if UE indicates only EIA0 ([#222](https://github.com/open5gs/open5gs/pull/222)) -- [laf0rge](https://github.com/laf0rge)
- Sending ErrorIndication if S1AP decoding is failed  ([#218](https://github.com/open5gs/open5gs/pull/218), [#219](https://github.com/open5gs/open5gs/pull/219)) -- [laf0rge](https://github.com/laf0rge)


Download -- [v0.5.1.tar.gz](https://github.com/open5gs/open5gs/archive/v0.5.1.tar.gz)
{: .notice--info}
