---
title: "v2.7.4 - Bug fixed"
date: 2025-03-26 20:08:00 +0900
categories:
  - Release
tags:
  - News
  - Release
head_inline: "<style> ul { padding-bottom: 1em; } .blue { color: blue; }</style>"
---

# Open5GS Release Note Summary

This release introduces numerous improvements and bug fixes across core network components, enhancing overall stability, performance, and security. Below is a concise overview of the key updates:

## Session & Subscription Management
- **SMF Enhancements:**
  Improved handling of SDM subscriptions to UDM during the PDU session lifetime.
- **Optional PLMN-ID:**
  Added support for an optional PLMN-ID parameter in SDM GET queries (AMF/SMF).
- **5GMM Cause Reporting:**
  AMF now sends a 5GMM cause in the request to SMF when initiating a session release.

## Mobility & Authentication Improvements
- **Mobility Fixes:**
  Corrected QoS values for 2G to 4G mobility and fixed issues with UE context release and cell reselection.
- **Security & Authentication:**
  Enhanced UE authentication processes, prevented crashes during security mode command failures, and implemented HSS selection improvements.

## Interface & Protocol Enhancements
- **Diameter & PFCP:**
  - Integrated statistics into the main loop for Diameter interfaces, with enhanced debug logging for HSS and PCRF.
  - Addressed multiple PFCP issues, including memory management, header handling, and correct TEID restoration.
- **NAS Module:**
  Fixed a heap-buffer overflow vulnerability in NAS message decoding.

## SBI and Other Module Updates
- **SBI Enhancements:**
  Enabled custom User-Agent header information for HTTP/2 requests, support for custom port numbers, and direct NRF communication.
- **Additional Fixes:**
  - Resolved UE context handling issues during handovers and state transitions.
  - Implemented various cosmetic fixes, typo corrections, and documentation updates.
  - Introduced support for new parameters and refined subscription conditions.

Overall, this release emphasizes improved network reliability, enhanced security measures, and better support for 5G core operations while also addressing legacy issues.

See [Release Note](https://github.com/open5gs/open5gs/releases/tag/v2.7.4)

Download -- [v2.7.4.tar.gz](https://github.com/open5gs/open5gs/archive/v2.7.4.tar.gz)
{: .notice--info}
