/*
 * This code was written by Mychaela Falconia <falcon@freecalypso.org>
 * who refuses to claim copyright on it and has released it as public domain
 * instead. NO rights reserved, all rights relinquished.
 *
 * Tweaked (coding style changes) by Vadim Yanitskiy <axilirator@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdint.h>
#include <rf/txcal.h>

/*
 * Mot C139/140 uses the same APC offset value as C11x, as verified by
 * breaking into a running C139 fw with tfc139, running fc-loadtool with
 * all ABB register state still intact from the interrupted official fw,
 * and reading the APCOFF register with the abbr command.
 */
uint8_t apc_offset = 32;

/*
 * The following tables of Tx ramp templates have been read out of an
 * official Mot C139 fw version via tms 1, rfpw 7 and ttr Test Mode commands.
 * Please note that these Tx ramp templates for the SKY77325 PA in Mot C139/140
 * phones are different from the older C11x/12x/155/156 (SKY77324) ones!
 */
struct txcal_ramp_def rf_tx_ramps_850[RF_TX_RAMP_SIZE] = {
      { /* profile 0 */
	/* ramp-up */
	{  0,  0,  3,  0,  0,  0,  0,  0,  2, 31, 30, 31, 31,  0,  0,  0},
	/* ramp-down */
	{ 20, 21, 31, 26, 10, 10, 10,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 1 */
	/* ramp-up */
	{  0,  0,  5,  0,  0,  0,  0,  0,  0, 31, 30, 31, 31,  0,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 2 */
	/* ramp-up */
	{  0,  0,  5,  0,  0,  0,  0,  0,  0, 31, 30, 31, 31,  0,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 3 */
	/* ramp-up */
	{  0,  0,  0,  5,  0,  0,  0,  0,  0, 31, 30, 31, 31,  0,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 4 */
	/* ramp-up */
	{  0,  0,  0,  5,  0,  0,  0,  0,  0, 31, 30, 31, 31,  0,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 5 */
	/* ramp-up */
	{  0,  0,  0,  8,  0,  0,  0,  0,  0, 28, 30, 31, 31,  0,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 6 */
	/* ramp-up */
	{  0,  0,  0,  8,  0,  0,  0,  0,  0, 28, 30, 31, 31,  0,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 7 */
	/* ramp-up */
	{  0,  0,  0, 12,  0,  0,  0,  0,  0, 20, 30, 31, 31,  4,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 8 */
	/* ramp-up */
	{  0,  0,  0, 12,  0,  0,  0,  0,  0, 20, 30, 31, 31,  4,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 9 */
	/* ramp-up */
	{  0,  0,  0, 17,  0,  0,  0,  0,  0, 25, 24, 31, 31,  0,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 10 */
	/* ramp-up */
	{  0,  0,  0, 17,  0,  0,  0,  0,  0, 25, 24, 31, 31,  0,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 11 */
	/* ramp-up */
	{  0,  0,  0, 17,  0,  0,  0,  0,  0, 14, 30, 31, 31,  5,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 12 */
	/* ramp-up */
	{  0,  0,  0, 17,  0,  0,  0,  0,  0, 14, 30, 31, 31,  5,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 13 */
	/* ramp-up */
	{  0,  0,  0, 28,  0,  0,  0,  0,  0,  0, 31, 31, 31,  7,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 14 */
	/* ramp-up */
	{  0,  0,  0, 28,  0,  0,  0,  0,  0,  0, 31, 31, 31,  7,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 15 */
	/* ramp-up */
	{  0,  0,  0, 28,  0,  0,  0,  0,  0,  0, 31, 31, 31,  7,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
};

struct txcal_ramp_def rf_tx_ramps_900[RF_TX_RAMP_SIZE] = {
      { /* profile 0 */
	/* ramp-up */
	{  0,  0,  2,  0,  0,  0,  0,  0, 13, 24, 24, 25, 26, 14,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 1 */
	/* ramp-up */
	{  0,  0,  3,  0,  0,  0,  0,  0, 16, 24, 24, 30, 31,  0,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 2 */
	/* ramp-up */
	{  0,  0,  3,  0,  0,  0,  0,  0, 16, 24, 24, 30, 31,  0,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 3 */
	/* ramp-up */
	{  0,  0,  0,  4,  0,  0,  0,  0,  0, 31, 31, 30, 30,  2,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 4 */
	/* ramp-up */
	{  0,  0,  0,  4,  0,  0,  0,  0,  0, 31, 31, 30, 30,  2,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 5 */
	/* ramp-up */
	{  0,  0,  0,  0, 15,  0,  0,  0,  0,  0, 31, 31, 31, 20,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 6 */
	/* ramp-up */
	{  0,  0,  0,  0, 15,  0,  0,  0,  0,  0, 31, 31, 31, 20,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 7 */
	/* ramp-up */
	{  0,  0,  0,  0, 15,  0,  0,  0,  0,  0, 31, 31, 31, 20,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 8 */
	/* ramp-up */
	{  0,  0,  0,  0, 15,  0,  0,  0,  0,  0, 31, 31, 31, 20,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 9 */
	/* ramp-up */
	{  0,  0,  0,  0, 18,  0,  0,  0,  0,  0, 31, 31, 31, 17,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 10 */
	/* ramp-up */
	{  0,  0,  0,  0, 20,  0,  0,  0,  0,  0, 31, 31, 31, 15,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 11 */
	/* ramp-up */
	{  0,  0,  0,  0, 25,  0,  0,  0,  0,  0, 31, 31, 31, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 12 */
	/* ramp-up */
	{  0,  0,  0,  0, 25,  0,  0,  0,  0,  0, 31, 31, 31, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 13 */
	/* ramp-up */
	{  0,  0,  0,  0, 25,  0,  0,  0,  0,  0, 31, 31, 31, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 14 */
	/* ramp-up */
	{  0,  0,  0,  0, 30,  0,  0,  0,  0,  0, 31, 31, 31,  5,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 15 */
	/* ramp-up */
	{  0,  0,  0,  0, 30,  0,  0,  0,  0,  0, 31, 31, 31,  5,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
};

struct txcal_ramp_def rf_tx_ramps_1800[RF_TX_RAMP_SIZE] = {
      { /* profile 0 */
	/* ramp-up */
	{  6,  0,  0,  0,  0,  0,  0,  0,  0, 26, 26, 30, 30, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 1 */
	/* ramp-up */
	{  6,  0,  0,  0,  0,  0,  0,  0,  0, 26, 26, 30, 30, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 2 */
	/* ramp-up */
	{  6,  0,  0,  0,  0,  0,  0,  0,  0, 26, 26, 30, 30, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 3 */
	/* ramp-up */
	{  6,  0,  0,  0,  0,  0,  0,  0,  0, 30, 30, 30, 30,  2,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 4 */
	/* ramp-up */
	{  6,  0,  0,  0,  0,  0,  0,  0,  0, 30, 30, 30, 30,  2,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 5 */
	/* ramp-up */
	{ 11,  0,  0,  0,  0,  0,  0,  0,  0, 15, 25, 26, 31, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 6 */
	/* ramp-up */
	{ 11,  0,  0,  0,  0,  0,  0,  0,  0, 15, 25, 26, 31, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 7 */
	/* ramp-up */
	{ 11,  0,  0,  0,  0,  0,  0,  0,  0, 15, 25, 26, 31, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 8 */
	/* ramp-up */
	{ 11,  0,  0,  0,  0,  0,  0,  0,  0, 15, 25, 26, 31, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 9 */
	/* ramp-up */
	{ 11,  0,  0,  0,  0,  0,  0,  0,  0, 15, 25, 26, 31, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 10 */
	/* ramp-up */
	{ 20,  0,  0,  0,  0,  0,  0,  0,  0,  0, 30, 30, 30, 18,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 11 */
	/* ramp-up */
	{ 20,  0,  0,  0,  0,  0,  0,  0,  0,  0, 30, 30, 30, 18,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 12 */
	/* ramp-up */
	{ 23,  0,  0,  0,  0,  0,  0,  0,  0,  0, 30, 30, 30, 15,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 13 */
	/* ramp-up */
	{ 28,  0,  0,  0,  0,  0,  0,  0,  0,  0, 30, 30, 30, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 14 */
	/* ramp-up */
	{ 31,  0,  0,  0,  0,  0,  0,  0,  0,  0, 30, 30, 30,  7,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 15 */
	/* ramp-up */
	{ 31,  0,  0,  0,  0,  0,  0,  0,  0,  0, 30, 30, 30,  7,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
};

struct txcal_ramp_def rf_tx_ramps_1900[RF_TX_RAMP_SIZE] = {
      { /* profile 0 */
	/* ramp-up */
	{ 10,  0,  0,  0,  0,  0,  0,  0,  6, 15, 31, 31, 23, 12,  0,  0},
	/* ramp-down */
	{ 31, 31, 27, 27, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 1 */
	/* ramp-up */
	{ 10,  0,  0,  0,  0,  0,  0,  0,  6, 15, 31, 31, 23, 12,  0,  0},
	/* ramp-down */
	{ 31, 31, 27, 27, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 2 */
	/* ramp-up */
	{ 10,  0,  0,  0,  0,  0,  0,  0,  6, 15, 31, 31, 23, 12,  0,  0},
	/* ramp-down */
	{ 31, 31, 27, 27, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 3 */
	/* ramp-up */
	{ 10,  0,  0,  0,  0,  0,  0,  0,  6, 15, 31, 31, 23, 12,  0,  0},
	/* ramp-down */
	{ 31, 31, 27, 27, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 4 */
	/* ramp-up */
	{ 10,  0,  0,  0,  0,  0,  0,  0,  6, 15, 31, 31, 23, 12,  0,  0},
	/* ramp-down */
	{ 31, 31, 27, 27, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 5 */
	/* ramp-up */
	{ 11,  0,  0,  0,  0,  0,  0,  0,  0, 15, 25, 26, 31, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 6 */
	/* ramp-up */
	{ 11,  0,  0,  0,  0,  0,  0,  0,  0, 15, 25, 26, 31, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 7 */
	/* ramp-up */
	{ 11,  0,  0,  0,  0,  0,  0,  0,  0, 15, 25, 26, 31, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 8 */
	/* ramp-up */
	{ 11,  0,  0,  0,  0,  0,  0,  0,  0, 15, 25, 26, 31, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 9 */
	/* ramp-up */
	{ 11,  0,  0,  0,  0,  0,  0,  0,  0, 15, 25, 26, 31, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 10 */
	/* ramp-up */
	{ 11,  0,  0,  0,  0,  0,  0,  0,  0, 15, 25, 26, 31, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 11 */
	/* ramp-up */
	{ 16,  0,  0,  0,  0,  0,  0,  0,  0, 10, 30, 31, 31, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 12 */
	/* ramp-up */
	{ 16,  0,  0,  0,  0,  0,  0,  0,  0, 10, 30, 31, 31, 10,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 13 */
	/* ramp-up */
	{ 19,  0,  0,  0,  0,  0,  0,  0,  0,  9, 31, 31, 31,  7,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 14 */
	/* ramp-up */
	{ 23,  0,  0,  0,  0,  0,  0,  0,  0, 25, 31, 31, 31,  7,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
      { /* profile 15 */
	/* ramp-up */
	{ 23,  0,  0,  0,  0,  0,  0,  0,  0, 25, 31, 31, 31,  7,  0,  0},
	/* ramp-down */
	{ 31, 31, 31, 31,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
      },
};
