-module(exometer_mock).

-export([mock_all/0,
         unmock_all/0]).


%% ------------------------------------------------------------------
%% public API
%% ------------------------------------------------------------------

%% mock all pfcp_peer module functions
mock_all() ->
    meck:new(exometer),
    meck:expect(exometer, new, fun(_Name, _Type) -> ok end),
    meck:expect(exometer, reset, fun(_Name) -> ok end),
    meck:expect(exometer, update, fun(_Name, _Value) -> ok end),
    meck:expect(exometer, get_value, fun(_Name, DataPoint) -> {ok,[{DataPoint,0}]} end).

%% unmock all pfcp_peer module functions
unmock_all() ->
    true = meck:validate(exometer),
    meck:unload(exometer).

%% vim:set ts=4 sw=4 et:
