typedef unsigned char API;
typedef signed char API_SIGNED;

struct db_mcu_to_dsp
{
	API d_task_d;
	API d_burst_d;
	API d_task_u;
	API d_burst_u;
	API d_task_md;
	API d_background;
	API d_debug;
	API d_task_ra;
	API d_fn;
	API d_ctrl_tch;
	API hole;
	API d_ctrl_abb;
	API a_a5fn[2];
	API d_power_ctl;
	API d_afc;
	API d_ctrl_system;
};

struct db_dsp_to_mcu
{
	API d_task_d;
	API d_burst_d;
	API d_task_u;
	API d_burst_u;
	API d_task_md;
	API d_background;
	API d_debug;
	API d_task_ra;
	API a_serv_demod[4];
	API a_pm[3];
	API a_sch[5];
};

struct param_mcu_dsp
{
	API_SIGNED d_transfer_rate;
	API_SIGNED d_lat_mcu_bridge;
	API_SIGNED d_lat_mcu_hom2sam;
	API_SIGNED d_lat_mcu_bef_fast_access;
	API_SIGNED d_lat_dsp_after_sam;
	API_SIGNED d_gprs_install_address;
	API_SIGNED d_misc_config;
	API_SIGNED d_cn_sw_workaround;
	API_SIGNED d_hole2_param[4];
	API_SIGNED d_fb_margin_beg;
	API_SIGNED d_fb_margin_end;
	API_SIGNED d_nsubb_idle;
	API_SIGNED d_nsubb_dedic;
	API_SIGNED d_fb_thr_det_iacq;
	API_SIGNED d_fb_thr_det_track;
	API_SIGNED d_dc_off_thres;
	API_SIGNED d_dummy_thres;
	API_SIGNED d_dem_pond_gewl;
	API_SIGNED d_dem_pond_red;
	API_SIGNED d_maccthresh1;
	API_SIGNED d_mldt;
	API_SIGNED d_maccthresh;
	API_SIGNED d_gu;
	API_SIGNED d_go;
	API_SIGNED d_attmax;
	API_SIGNED d_sm;
	API_SIGNED d_b;
	API_SIGNED d_v42b_switch_hyst;
	API_SIGNED d_v42b_switch_min;
	API_SIGNED d_v42b_switch_max;
	API_SIGNED d_v42b_reset_delay;
	API_SIGNED d_ldT_hr;
	API_SIGNED d_maccthresh_hr;
	API_SIGNED d_maccthresh1_hr;
	API_SIGNED d_gu_hr;
	API_SIGNED d_go_hr;
	API_SIGNED d_b_hr;
	API_SIGNED d_sm_hr;
	API_SIGNED d_attmax_hr;
	API_SIGNED c_mldt_efr;
	API_SIGNED c_maccthresh_efr;
	API_SIGNED c_maccthresh1_efr;
	API_SIGNED c_gu_efr;
	API_SIGNED c_go_efr;
	API_SIGNED c_b_efr;
	API_SIGNED c_sm_efr;
	API_SIGNED c_attmax_efr;
	API_SIGNED d_sd_min_thr_tchfs;
	API_SIGNED d_ma_min_thr_tchfs;
	API_SIGNED d_md_max_thr_tchfs;
	API_SIGNED d_md1_max_thr_tchfs;
	API_SIGNED d_sd_min_thr_tchhs;
	API_SIGNED d_ma_min_thr_tchhs;
	API_SIGNED d_sd_av_thr_tchhs;
	API_SIGNED d_md_max_thr_tchhs;
	API_SIGNED d_md1_max_thr_tchhs;
	API_SIGNED d_sd_min_thr_tchefs;
	API_SIGNED d_ma_min_thr_tchefs;
	API_SIGNED d_md_max_thr_tchefs;
	API_SIGNED d_md1_max_thr_tchefs;
	API_SIGNED d_wed_fil_ini;
	API_SIGNED d_wed_fil_tc;
	API_SIGNED d_x_min;
	API_SIGNED d_x_max;
	API_SIGNED d_slope;
	API_SIGNED d_y_min;
	API_SIGNED d_y_max;
	API_SIGNED d_wed_diff_threshold;
	API_SIGNED d_mabfi_min_thr_tchhs;
	API_SIGNED d_facch_thr;
	API_SIGNED d_max_ovsp_ul;
	API_SIGNED d_sync_thres;
	API_SIGNED d_idle_thres;
	API_SIGNED d_m1_thres;
	API_SIGNED d_max_ovsp_dl;
	API_SIGNED d_gsm_bgd_mgt;
	API a_fir_holes[4];
	API a_fir31_uplink[31];
	API a_fir31_downlink[31];
};

struct ndb_mcu_dsp
{
	API d_dsp_page;
	API d_error_status;
	API d_spcx_rif;
	API d_tch_mode;
	API d_debug1;
	API d_dsp_test;
	API d_version_number1;
	API d_version_number2;
	API d_debug_ptr;
	API d_debug_bk;
	API d_pll_config;
	API p_debug_buffer;
	API d_debug_buffer_size;
	API d_debug_trace_type;
	API d_dsp_state;
	API d_hole1_ndb[2];
	API d_hole_debug_amr;
	API d_hole2_ndb[1];
	API d_mcsi_select;
	API d_apcdel1_bis;
	API d_apcdel2_bis;
	API d_apcdel2;
	API d_vbctrl2;
	API d_bulgcal;
	API d_afcctladd;
	API d_vbuctrl;
	API d_vbdctrl;
	API d_apcdel1;
	API d_apcoff;
	API d_bulioff;
	API d_bulqoff;
	API d_dai_onoff;
	API d_auxdac;
	API d_vbctrl1;
	API d_bbctrl;
	API d_fb_det;
	API d_fb_mode;
	API a_sync_demod[4];
	API a_sch26[5];
	API d_audio_gain_ul;
	API d_audio_gain_dl;
	API d_audio_compressor_ctrl;
	API d_audio_init;
	API d_audio_status;
	API d_toneskb_init;
	API d_toneskb_status;
	API d_k_x1_t0;
	API d_k_x1_t1;
	API d_k_x1_t2;
	API d_pe_rep;
	API d_pe_off;
	API d_se_off;
	API d_bu_off;
	API d_t0_on;
	API d_t0_off;
	API d_t1_on;
	API d_t1_off;
	API d_t2_on;
	API d_t2_off;
	API d_k_x1_kt0;
	API d_k_x1_kt1;
	API d_dur_kb;
	API d_shiftdl;
	API d_shiftul;
	API d_aec_ctrl;
	API d_es_level_api;
	API d_mu_api;
	API d_melo_osc_used;
	API d_melo_osc_active;
	API a_melo_note0[4];
	API a_melo_note1[4];
	API a_melo_note2[4];
	API a_melo_note3[4];
	API a_melo_note4[4];
	API a_melo_note5[4];
	API a_melo_note6[4];
	API a_melo_note7[4];
	API d_melody_selection;
	API a_melo_holes[3];
	API d_sr_status;
	API d_sr_param;
	API d_sr_bit_exact_test;
	API d_sr_nb_words;
	API d_sr_db_level;
	API d_sr_db_noise;
	API d_sr_mod_size;
	API a_n_best_words[4];
	API a_n_best_score[8];
	API a_dd_1[22];
	API a_du_1[22];
	API d_v42b_nego0;
	API d_v42b_nego1;
	API d_v42b_control;
	API d_v42b_ratio_ind;
	API d_mcu_control;
	API d_mcu_control_sema;
	API d_background_enable;
	API d_background_abort;
	API d_background_state;
	API d_max_background;
	API a_background_tasks[16];
	API a_back_task_io[16];
	API d_gea_mode_ovly;
	API a_gea_kc_ovly[4];
	API d_hole3_ndb[7];
	API d_thr_usf_detect;
	API d_a5mode;
	API d_sched_mode_gprs_ovly;
	API d_hole4_ndb[5];
	API a_ramp[16];
	API a_cd[15];
	API a_fd[15];
	API a_dd_0[22];
	API a_cu[15];
	API a_fu[15];
	API a_du_0[22];
	API d_rach;
	API a_kc[4];
	API d_ra_conf;
	API d_ra_act;
	API d_ra_test;
	API d_ra_statu;
	API d_ra_statd;
	API d_fax;
	API a_data_buf_ul[21];
	API a_data_buf_dl[37];
	API a_tty_holes[8];
	API a_sr_holes0[414];
	API a_new_aec_holes[12];
	// API a_sr_holes1[145];
	struct param_mcu_dsp params;
	API d_cport_init;
	API d_cport_ctrl;
	API a_cport_cfr[2];
	API d_cport_tcl_tadt;
	API d_cport_tdat;
	API d_cport_tvs;
	API d_cport_status;
	API d_cport_reg_value;
	API a_cport_holes[1011];
	API a_model[1041];
	API a_eotd_holes[22];
	API a_amr_config[4];
	API a_ratscch_ul[6];
	API a_ratscch_dl[6];
	API d_amr_snr_est;
	API a_voice_memo_amr_holes[1];
	API d_thr_onset_afs;
	API d_thr_sid_first_afs;
	API d_thr_ratscch_afs;
	API d_thr_update_afs;
	API d_thr_onset_ahs;
	API d_thr_sid_ahs;
	API d_thr_ratscch_marker;
	API d_thr_sp_dgr;
	API d_thr_soft_bits;
	API d_holes[61];
};

enum dsp_error {
	DSP_ERR_RHEA		= 0x0001,
	DSP_ERR_IQ_SAMPLES	= 0x0004,
	DSP_ERR_DMA_PROG	= 0x0008,
	DSP_ERR_DMA_TASK	= 0x0010,
	DSP_ERR_DMA_PEND	= 0x0020,
	DSP_ERR_VM		= 0x0080,
	DSP_ERR_DMA_UL_TASK	= 0x0100,
	DSP_ERR_DMA_UL_PROG	= 0x0200,
	DSP_ERR_DMA_UL_PEND	= 0x0400,
	DSP_ERR_STACK_OV	= 0x0800,
};
