-module(pkt_mpls_tests).

-include_lib("pkt/include/pkt.hrl").
-include_lib("eunit/include/eunit.hrl").

codec_test_() ->
    [decode_single_tagging(),
     decode_double_tagging()].

decode_single_tagging() ->
    Frame = pkt:decapsulate(single()),
    Expect = [{ether,<<194,5,99,77,0,0>>,<<194,3,99,62,0,0>>,34887,0},
              {mpls,[{shim,18,0,true,254}]},
              {ipv4,4,5,0,100,25,0,0,0,254,1,2349,{192,168,10,1},{192,168,40,1},<<>>},
              {icmp,8,0,28057,5,0,{127,0,0,1},<<0,0,0,0>>,0,0,0,0,0},
              <<0,0,0,0,0,36,16,136,171,205,171,205,171,205,171,205,171,205,171,205,171,
                205,171,205,171,205,171,205,171,205,171,205,171,205,171,205,171,205,171,
                205,171,205,171,205,171,205,171,205,171,205,171,205,171,205,171,205,171,
                205,171,205,171,205,171,205,171,205,171,205,171,205,171,205>>],
    ?_assertEqual(Frame, Expect).

decode_double_tagging() ->
    Frame = pkt:decapsulate(double()),
    Expect =  [{ether,<<0,48,150,230,252,57>>,<<0,48,150,5,40,56>>,34887,0},
               {mpls,[{shim,18,0,false,255},{shim,16,0,true,255}]},
               {ipv4,4,5,0,100,80,0,0,0,255,1,42758,{10,31,0,1},{10,34,0,1},<<>>},
               {icmp,8,0,48401,3941,4768,{127,0,0,1},<<0,0,0,0>>,0,0,0,0,0},
               <<0,0,0,0,0,83,158,224,171,205,171,205,171,205,171,205,171,205,171,205,171,
                 205,171,205,171,205,171,205,171,205,171,205,171,205,171,205,171,205,171,
                 205,171,205,171,205,171,205,171,205,171,205,171,205,171,205,171,205,171,
                 205,171,205,171,205,171,205,171,205,171,205,171,205,171,205>>],
    ?_assertEqual(Frame, Expect).

single() ->
    <<16#c2, 16#05, 16#63, 16#4d, 16#00, 16#00, 16#c2, 16#03,
      16#63, 16#3e, 16#00, 16#00, 16#88, 16#47, 16#00, 16#01,
      16#21, 16#fe, 16#45, 16#00, 16#00, 16#64, 16#00, 16#19,
      16#00, 16#00, 16#fe, 16#01, 16#09, 16#2d, 16#c0, 16#a8,
      16#0a, 16#01, 16#c0, 16#a8, 16#28, 16#01, 16#08, 16#00,
      16#6d, 16#99, 16#00, 16#05, 16#00, 16#00, 16#00, 16#00,
      16#00, 16#00, 16#00, 16#24, 16#10, 16#88, 16#ab, 16#cd,
      16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd,
      16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd,
      16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd,
      16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd,
      16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd,
      16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd,
      16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd,
      16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd>>.

double() ->
    <<16#00, 16#30, 16#96, 16#e6, 16#fc, 16#39, 16#00, 16#30,
      16#96, 16#05, 16#28, 16#38, 16#88, 16#47, 16#00, 16#01,
      16#20, 16#ff, 16#00, 16#01, 16#01, 16#ff, 16#45, 16#00,
      16#00, 16#64, 16#00, 16#50, 16#00, 16#00, 16#ff, 16#01,
      16#a7, 16#06, 16#0a, 16#1f, 16#00, 16#01, 16#0a, 16#22,
      16#00, 16#01, 16#08, 16#00, 16#bd, 16#11, 16#0f, 16#65,
      16#12, 16#a0, 16#00, 16#00, 16#00, 16#00, 16#00, 16#53,
      16#9e, 16#e0, 16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd,
      16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd,
      16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd,
      16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd,
      16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd,
      16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd,
      16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd,
      16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd, 16#ab, 16#cd,
      16#ab, 16#cd>>.
