osmo-s1gw
=========

This is an S1AP (S1 Application Protocol) Gateway implementation in Erlang for
the 3GPP EPC (Evolved Packet Core) based (4G/LTE) networks.  It is part of the
[Osmocom](https://osmocom.org/) Open Source Mobile Communications project.

S1AP is a protocol "spoken" between the eNB and the MME.  The S1GW is useful in
scenarios when eNB(s) and the MME co-exist in separate networks and thus unable
to access each other directly.  This is basically a proxy, accepting incoming
connections from eNB(s), establishing the associated outgoing connections
to the MME, and forwarding S1AP PDUs back and forth.

```
          (network A) |
                      |
               +-------------+     +-------------+
               |  osmo-s1gw  |     |     MME     |
+--------+     +-------------+     +-------------+
| eNB(1) | --> |             | --> |             |
+--------+     |             |     |             |
               |             |     |             |
+--------+     |             |     |             |
| eNB(2) | --> |             | --> |             |
+--------+     |             |     |             |
               |             |     |             |
+--------+     |             |     |             |
| eNB(N) | --> |             | --> |             |
+--------+     +-------------+     +-------------+
                      |
                      | (network B)
```


Homepage
--------

This project does not have its own homepage yet, unlike many other
[Osmocom projects](https://osmocom.org/projects/).


GIT Repository
--------------

You can clone from the official osmo-s1gw.git repository using

```
$ git clone https://gitea.osmocom.org/erlang/osmo-s1gw
```

There is a web interface at <https://gitea.osmocom.org/erlang/osmo-s1gw>


Documentation
-------------

Once the project reaches a usable milestone, we will be working on a
user manual.  Stay tuned.


Contributing
------------

Our coding standards are described at
<https://osmocom.org/projects/cellular-infrastructure/wiki/Coding_standards>.

We use a Gerrit based patch submission/review process for managing
contributions.  Please see
<https://osmocom.org/projects/cellular-infrastructure/wiki/Gerrit> for
more details.

The current patch queue for osmo-s1gw can be seen at
<https://gerrit.osmocom.org/#/q/project:erlang/osmo-s1gw+status:open>.


Building
--------

Install erlang and rebar3 packages (not "rebar", that's version 2! You may need
to compile it from source in some distros).

```
$ make
```


Testing
-------

Unit tests can be run this way:

```
$ make check
```

Additionally, you can run the static analyser (Dialyzer):

```
$ make analyze
```


Running
-------

Once OsmoS1GW is built, you can start it this way:

```
$ make run
```


Installation
------------

OsmoS1GW is built for common versions of Debian, Ubuntu and other distributions as a part of
the [Osmocom binary packages](https://osmocom.org/projects/cellular-infrastructure/wiki/Binary_Packages).
If you're not doing development, it is suggested to simply use those binary packages, rather
than building from source.  Otherwise, you can invoke the `install` target:

```
$ sudo make install
```

This will install the following:

* `/usr/lib/osmo-s1gw` - complete OTP release package
* `/usr/bin/osmo-s1gw` - convenience script for running `osmo-s1gw`
* `/usr/bin/osmo-s1gw-cli` - interactive CLI for `osmo-s1gw`
* `/lib/systemd/system/osmo-s1gw.service` - systemd unit file
* `/etc/osmocom/osmo-s1gw.config` - the configuration file

The installation paths can be adjusted using `DESTDIR`, `LIBDIR`, `BINDIR`,
`CONFDIR`, and `SYSTEMDUNITDIR` variables.


Configuration
-------------

The default configuration can be found in
[config/sys.config](config/sys.config).

The existing parameters can be represented as follows:

```
  eNB              S1GW
+-----+     +----------------+
| ... | --> | s1gw_bind_addr |             MME
+-----+     +----------------+     +-----------------+
            |  mme_loc_addr  | --> |  mme_rem_addr   |
            +----------------+     +-----------------+
```

* `s1gw_bind_addr` - S1GW bind address for incoming eNB connections
* `mme_loc_addr` - local address for outgoing connections to the MME
* `mme_rem_addr` - remote address for outgoing connections to the MME

Logging can be configured in the `kernel` section:

* `{logger_level, info}` - logging level (one of `emergency | alert |
                           critical | error | warning | notice |
                           info | debug`)
* `#{formatter => { ... }` - logging formatting configuration


REST interface
--------------

OsmoS1GW implements a custom (non-standard) REST interface, primarily intended
for state introspection.  The interface is specified using OpenAPI, with the
specification available in [contrib/openapi.yaml](contrib/openapi.yaml).

You can explore the API and available endpoints interactively via
the Swagger UI by opening <http://localhost:8080/swagger> in a browser.

The OpenAPI specification is provided in two formats:

* **YAML** (`contrib/openapi.yaml`) is the primary specification document.
* **JSON** (`priv/openapi.json`) is generated from the YAML using
[contrib/yaml2json.py](contrib/yaml2json.py) and used as input by the
ERF framework for automatic code generation and the request validation.

> **Note:** Both files must be kept in sync.  When making changes to the YAML
document, make sure to update the JSON counterpart by invoking `make openapi`.


Interactive CLI
---------------

OsmoS1GW comes with [`osmo-s1gw-cli.py`](contrib/osmo-s1gw-cli.py) - an interactive
shell based on Python's **cmd2** library.  This script serves as an alternative to the
traditional telnet/VTY interface found in many Osmocom projects.  For more details,
see (doc/osmo-s1gw-cli.md).
