-module(s1ap_samples).

-export([s1_setup_req_pdu/0,
         s1_setup_rsp_pdu/0,
         e_rab_setup_req_pdu/2,
         e_rab_setup_rsp_pdu/2,
         e_rab_setup_rsp_fail_pdu/0,
         e_rab_release_cmd_pdu/0,
         e_rab_release_rsp_pdu/0,
         e_rab_release_ind_pdu/0,
         e_rab_modify_req_pdu/2,
         e_rab_modify_rsp_pdu/0,
         e_rab_modify_rsp_fail_pdu/0,
         e_rab_modify_ind_pdu/2,
         e_rab_modify_cnf_pdu/1,
         initial_context_setup_req_pdu/2,
         initial_context_setup_rsp_pdu/2,
         ue_ctx_release_req_pdu/0,
         ue_ctx_release_cmd_pdu/0,
         ue_ctx_release_compl_pdu/0,
         handover_required_pdu/0,
         handover_command_pdu/0,
         handover_request_pdu/2,
         handover_request_ack_pdu/2]).


%% ------------------------------------------------------------------
%% S1AP PDU samples
%% ------------------------------------------------------------------

%% S1 SETUP REQUEST
s1_setup_req_pdu() ->
    << 16#00, 16#11, 16#00, 16#1a, 16#00, 16#00, 16#02, 16#00,
       16#3b, 16#40, 16#08, 16#00, 16#00, 16#f1, 16#10, 16#00,
       16#00, 16#00, 16#00, 16#00, 16#40, 16#00, 16#07, 16#00,
       16#0c, 16#0e, 16#40, 16#00, 16#f1, 16#10
    >>.


%% S1 SETUP RESPONSE
s1_setup_rsp_pdu() ->
    << 16#20, 16#11, 16#00, 16#29, 16#00, 16#00, 16#03, 16#00,
       16#3d, 16#40, 16#0e, 16#05, 16#80, 16#6f, 16#70, 16#65,
       16#6e, 16#35, 16#67, 16#73, 16#2d, 16#6d, 16#6d, 16#65,
       16#30, 16#00, 16#69, 16#00, 16#0b, 16#00, 16#00, 16#00,
       16#f1, 16#10, 16#00, 16#00, 16#00, 16#02, 16#00, 16#01,
       16#00, 16#57, 16#40, 16#01, 16#ff
    >>.


%% [eNB <- MME] E-RAB SETUP REQUEST
e_rab_setup_req_pdu(TLA, TEID) when is_binary(TLA),
                                    is_integer(TEID) ->
    << 16#00, 16#05, 16#00, 16#80, 16#9b, 16#00, 16#00, 16#03,
       16#00, 16#00, 16#00, 16#02, 16#00, 16#07, 16#00, 16#08,
       16#00, 16#02, 16#00, 16#09, 16#00, 16#10, 16#00, 16#80,
       16#87, 16#00, 16#00, 16#11, 16#00, 16#80, 16#81, 16#0c,
       16#00, 16#05, 16#04, 16#0f, 16#80,
       TLA/bytes, %% transportLayerAddress (IPv4)
       TEID:32/big, %% GTP-TEID
       16#72, 16#27, 16#c8,
       16#1a, 16#bc, 16#ec, 16#11, 16#62, 16#54, 16#c1, 16#01,
       16#05, 16#04, 16#03, 16#69, 16#6d, 16#73, 16#05, 16#01,
       16#c0, 16#a8, 16#65, 16#02, 16#5e, 16#02, 16#b3, 16#8c,
       16#58, 16#32, 16#27, 16#54, 16#80, 16#80, 16#21, 16#10,
       16#02, 16#00, 16#00, 16#10, 16#81, 16#06, 16#08, 16#08,
       16#08, 16#08, 16#83, 16#06, 16#08, 16#08, 16#04, 16#04,
       16#00, 16#0d, 16#04, 16#08, 16#08, 16#08, 16#08, 16#00,
       16#0d, 16#04, 16#08, 16#08, 16#04, 16#04, 16#00, 16#03,
       16#10, 16#20, 16#01, 16#48, 16#60, 16#48, 16#60, 16#00,
       16#00, 16#00, 16#00, 16#00, 16#00, 16#00, 16#00, 16#88,
       16#88, 16#00, 16#03, 16#10, 16#20, 16#01, 16#48, 16#60,
       16#48, 16#60, 16#00, 16#00, 16#00, 16#00, 16#00, 16#00,
       16#00, 16#00, 16#88, 16#44, 16#00, 16#0c, 16#04, 16#ac,
       16#16, 16#00, 16#15, 16#00, 16#10, 16#02, 16#05, 16#78
    >>.


%% [eNB -> MME] E-RAB SETUP RESPONSE
e_rab_setup_rsp_pdu(TLA, TEID) when is_binary(TLA),
                                    is_integer(TEID) ->
    << 16#20, 16#05, 16#00, 16#22, 16#00, 16#00, 16#03, 16#00,
       16#00, 16#40, 16#02, 16#00, 16#07, 16#00, 16#08, 16#40,
       16#02, 16#00, 16#09, 16#00, 16#1c, 16#40, 16#0f, 16#00,
       16#00, 16#27, 16#40, 16#0a, 16#0c, 16#1f,
       TLA/bytes, %% transportLayerAddress (IPv4)
       TEID:32/big %% GTP-TEID
    >>.


%% [S1GW -> MME] E-RAB SETUP RESPONSE (failure)
%% Transport-cause: transport-resource-unavailable
e_rab_setup_rsp_fail_pdu() ->
    << 16#20, 16#05, 16#00, 16#1a, 16#00, 16#00, 16#03, 16#00,
       16#00, 16#40, 16#02, 16#00, 16#07, 16#00, 16#08, 16#40,
       16#02, 16#00, 16#09, 16#00, 16#1d, 16#40, 16#07, 16#00,
       16#00, 16#23, 16#40, 16#02, 16#0c, 16#20
    >>.


%% [eNB <- MME] E-RAB RELEASE COMMAND
%% TODO: make E-RAB IDs configurable
e_rab_release_cmd_pdu() ->
    << 16#00, 16#07, 16#00, 16#1a, 16#00, 16#00, 16#03, 16#00,
       16#00, 16#00, 16#02, 16#00, 16#07, 16#00, 16#08, 16#00,
       16#02, 16#00, 16#09, 16#00, 16#21, 16#40, 16#07, 16#00,
       16#00, 16#23, 16#40, 16#02, 16#0c, 16#40
    >>.


%% [eNB -> MME] E-RAB RELEASE RESPONSE
%% TODO: make E-RAB IDs configurable
e_rab_release_rsp_pdu() ->
    << 16#20, 16#07, 16#00, 16#19, 16#00, 16#00, 16#03, 16#00,
       16#00, 16#00, 16#02, 16#00, 16#07, 16#00, 16#08, 16#00,
       16#02, 16#00, 16#09, 16#00, 16#45, 16#40, 16#06, 16#00,
       16#00, 16#0f, 16#40, 16#01, 16#0c
    >>.


%% [eNB -> MME] E-RAB RELEASE INDICATION
%% TODO: make E-RAB IDs configurable
e_rab_release_ind_pdu() ->
    << 16#00, 16#08, 16#00, 16#1a, 16#00, 16#00, 16#03, 16#00,
       16#00, 16#00, 16#02, 16#00, 16#07, 16#00, 16#08, 16#00,
       16#02, 16#00, 16#09, 16#00, 16#6e, 16#40, 16#07, 16#00,
       16#00, 16#23, 16#40, 16#02, 16#0c, 16#40
    >>.


%% [eNB <- MME] E-RAB MODIFY REQUEST
e_rab_modify_req_pdu(TLA, TEID) when is_binary(TLA),
                                     is_integer(TEID) ->
    << 16#00, 16#06, 16#00, 16#2d, 16#00, 16#00, 16#03, 16#00,
       16#00, 16#00, 16#02, 16#00, 16#07, 16#00, 16#08, 16#00,
       16#02, 16#00, 16#09, 16#00, 16#1e, 16#00, 16#1a, 16#00,
       16#00, 16#24, 16#00, 16#15, 16#4c, 16#00, 16#05, 16#04,
       16#00, 16#00, 16#00, 16#00, 16#b9, 16#00, 16#0a, 16#07,
       16#c0,
       TLA/bytes, %% transportLayerAddress (IPv4)
       TEID:32/big %% GTP-TEID
    >>.


%% [eNB -> MME] E-RAB MODIFY RESPONSE (success)
e_rab_modify_rsp_pdu() ->
    << 16#20, 16#06, 16#00, 16#19, 16#00, 16#00, 16#03, 16#00,
       16#00, 16#40, 16#02, 16#00, 16#07, 16#00, 16#08, 16#40,
       16#02, 16#00, 16#09, 16#00, 16#1f, 16#40, 16#06, 16#00,
       16#00, 16#25, 16#40, 16#01, 16#0c
    >>.


%% [eNB -> MME] E-RAB MODIFY RESPONSE (failure)
e_rab_modify_rsp_fail_pdu() ->
    << 16#20, 16#06, 16#00, 16#1a, 16#00, 16#00, 16#03, 16#00,
       16#00, 16#40, 16#02, 16#00, 16#07, 16#00, 16#08, 16#40,
       16#02, 16#00, 16#09, 16#00, 16#20, 16#40, 16#07, 16#00,
       16#00, 16#23, 16#40, 16#02, 16#0c, 16#40
    >>.


%% [eNB -> MME] E-RAB MODIFICATION INDICATION
e_rab_modify_ind_pdu(TLA, TEID) when is_binary(TLA),
                                     is_integer(TEID) ->
    << 16#00, 16#32, 16#00, 16#22, 16#00, 16#00, 16#03, 16#00,
       16#00, 16#00, 16#02, 16#00, 16#07, 16#00, 16#08, 16#00,
       16#02, 16#00, 16#09, 16#00, 16#c7, 16#00, 16#0f, 16#00,
       16#00, 16#c8, 16#00, 16#0a, 16#0c, 16#1f,
       TLA/bytes, %% transportLayerAddress (IPv4)
       TEID:32/big %% GTP-TEID
    >>.


%% [eNB -> MME] E-RAB MODIFICATION CONFIRMATION
e_rab_modify_cnf_pdu(Res) ->
    IEs = case Res of
        modified ->
            << 16#00, 16#cb, 16#40, 16#06, 16#00,
               16#00, 16#cc, 16#40, 16#01, 16#0c >>;
        not_modified ->
            %% cause: transport: transport-resource-unavailable (0)
            << 16#00, 16#cd, 16#40, 16#07, 16#00,
               16#00, 16#23, 16#40, 16#02, 16#0c, 16#20 >>;
        release ->
            %% cause: transport: transport-resource-unavailable (0)
            << 16#00, 16#d2, 16#40, 16#07, 16#00,
               16#00, 16#23, 16#40, 16#02, 16#0c, 16#20 >>
    end,
    << 16#20, 16#32, 16#00, (15 + byte_size(IEs)),
       16#00, 16#00, 16#03, 16#00, 16#00, 16#40, 16#02, 16#00,
       16#07, 16#00, 16#08, 16#40, 16#02, 16#00, 16#09,
       IEs/bytes
    >>.


%% [eNB <- MME] INITIAL CONTEXT SETUP REQUEST
initial_context_setup_req_pdu(TLA, TEID) when is_binary(TLA),
                                              is_integer(TEID) ->
    << 16#00, 16#09, 16#00, 16#81, 16#10, 16#00, 16#00, 16#07,
       16#00, 16#00, 16#00, 16#02, 16#00, 16#01, 16#00, 16#08,
       16#00, 16#02, 16#00, 16#01, 16#00, 16#42, 16#00, 16#0a,
       16#18, 16#3b, 16#9a, 16#ca, 16#00, 16#60, 16#3b, 16#9a,
       16#ca, 16#00, 16#00, 16#18, 16#00, 16#80, 16#b5, 16#00,
       16#00, 16#34, 16#00, 16#80, 16#af, 16#45, 16#00, 16#09,
       16#20, 16#0f, 16#80,
       TLA/bytes, %% transportLayerAddress (IPv4)
       TEID:32/big, %% GTP-TEID
       16#80, 16#9f, 16#27, 16#bd, 16#de,
       16#61, 16#4e, 16#02, 16#07, 16#42, 16#02, 16#29, 16#06,
       16#40, 16#32, 16#f8, 16#10, 16#00, 16#01, 16#00, 16#6e,
       16#52, 16#05, 16#c1, 16#01, 16#09, 16#09, 16#08, 16#69,
       16#6e, 16#74, 16#65, 16#72, 16#6e, 16#65, 16#74, 16#05,
       16#01, 16#c0, 16#a8, 16#64, 16#02, 16#5e, 16#06, 16#fe,
       16#fe, 16#fa, 16#fa, 16#02, 16#02, 16#58, 16#32, 16#27,
       16#4d, 16#80, 16#80, 16#21, 16#10, 16#02, 16#00, 16#00,
       16#10, 16#81, 16#06, 16#08, 16#08, 16#08, 16#08, 16#83,
       16#06, 16#08, 16#08, 16#04, 16#04, 16#00, 16#0d, 16#04,
       16#08, 16#08, 16#08, 16#08, 16#00, 16#0d, 16#04, 16#08,
       16#08, 16#04, 16#04, 16#00, 16#03, 16#10, 16#20, 16#01,
       16#48, 16#60, 16#48, 16#60, 16#00, 16#00, 16#00, 16#00,
       16#00, 16#00, 16#00, 16#00, 16#88, 16#88, 16#00, 16#03,
       16#10, 16#20, 16#01, 16#48, 16#60, 16#48, 16#60, 16#00,
       16#00, 16#00, 16#00, 16#00, 16#00, 16#00, 16#00, 16#88,
       16#44, 16#00, 16#10, 16#02, 16#05, 16#aa, 16#50, 16#0b,
       16#f6, 16#32, 16#f8, 16#10, 16#00, 16#02, 16#01, 16#c0,
       16#00, 16#02, 16#86, 16#13, 16#32, 16#f8, 16#10, 16#00,
       16#01, 16#23, 16#05, 16#f4, 16#04, 16#94, 16#25, 16#f8,
       16#64, 16#02, 16#01, 16#08, 16#00, 16#6b, 16#00, 16#05,
       16#1c, 16#00, 16#0e, 16#00, 16#00, 16#00, 16#49, 16#00,
       16#20, 16#57, 16#5d, 16#d3, 16#66, 16#69, 16#73, 16#4c,
       16#8c, 16#48, 16#42, 16#76, 16#5f, 16#fe, 16#f9, 16#bd,
       16#d5, 16#89, 16#08, 16#ae, 16#f6, 16#f4, 16#88, 16#62,
       16#22, 16#d7, 16#80, 16#fb, 16#36, 16#33, 16#d9, 16#9e,
       16#9f, 16#00, 16#c0, 16#40, 16#08, 16#35, 16#87, 16#61,
       16#10, 16#03, 16#ff, 16#ff, 16#74
    >>.


%% [eNB -> MME] INITIAL CONTEXT SETUP RESPONSE
initial_context_setup_rsp_pdu(TLA, TEID) when is_binary(TLA),
                                              is_integer(TEID) ->
    << 16#20, 16#09, 16#00, 16#22, 16#00, 16#00, 16#03, 16#00,
       16#00, 16#40, 16#02, 16#00, 16#01, 16#00, 16#08, 16#40,
       16#02, 16#00, 16#01, 16#00, 16#33, 16#40, 16#0f, 16#00,
       16#00, 16#32, 16#40, 16#0a, 16#0a, 16#1f,
       TLA/bytes, %% transportLayerAddress (IPv4)
       TEID:32/big %% GTP-TEID
    >>.


%% [eNB -> MME] UE CONTEXT RELEASE REQUEST
ue_ctx_release_req_pdu() ->
    << 16#00, 16#12, 16#40, 16#14, 16#00, 16#00, 16#03, 16#00,
       16#00, 16#00, 16#02, 16#00, 16#01, 16#00, 16#08, 16#00,
       16#02, 16#00, 16#01, 16#00, 16#02, 16#40, 16#01, 16#20
    >>.


%% [eNB <- MME] UE CONTEXT RELEASE COMMAND
ue_ctx_release_cmd_pdu() ->
    << 16#00, 16#17, 16#00, 16#10, 16#00, 16#00, 16#02, 16#00,
       16#63, 16#00, 16#04, 16#00, 16#01, 16#00, 16#01, 16#00,
       16#02, 16#40, 16#01, 16#20
    >>.


%% [eNB -> MME] UE CONTEXT RELEASE COMPLETE
ue_ctx_release_compl_pdu() ->
    << 16#20, 16#17, 16#00, 16#0f, 16#00, 16#00, 16#02, 16#00,
       16#00, 16#40, 16#02, 16#00, 16#01, 16#00, 16#08, 16#40,
       16#02, 16#00, 16#01
    >>.


%% [eNB -> MME] HANDOVER REQUIRED
handover_required_pdu() ->
    << 16#00, 16#00, 16#00, 16#35, 16#00, 16#00, 16#06, 16#00,
       16#00, 16#00, 16#03, 16#40, 16#10, 16#92, 16#00, 16#08,
       16#00, 16#02, 16#00, 16#00, 16#00, 16#01, 16#00, 16#01,
       16#00, 16#00, 16#02, 16#40, 16#02, 16#04, 16#20, 16#00,
       16#04, 16#00, 16#0e, 16#00, 16#62, 16#f2, 16#10, 16#40,
       16#00, 16#00, 16#00, 16#00, 16#62, 16#f2, 16#10, 16#00,
       16#07, 16#00, 16#68, 16#00, 16#04, 16#03, 16#12, 16#34,
       16#56
    >>.


%% [MME -> eNB] HANDOVER COMMAND
handover_command_pdu() ->
    << 16#20, 16#00, 16#00, 16#28, 16#00, 16#00, 16#05, 16#00,
       16#00, 16#00, 16#03, 16#40, 16#10, 16#92, 16#00, 16#08,
       16#00, 16#02, 16#00, 16#00, 16#00, 16#01, 16#00, 16#01,
       16#00, 16#00, 16#0c, 16#40, 16#07, 16#00, 16#00, 16#0e,
       16#40, 16#02, 16#00, 16#00, 16#00, 16#7b, 16#00, 16#04,
       16#03, 16#12, 16#34, 16#56
    >>.


%% [MME -> eNB] HANDOVER REQUEST
handover_request_pdu(TLA, TEID) when is_binary(TLA),
                                     is_integer(TEID) ->
    << 16#00, 16#01, 16#00, 16#6f, 16#00, 16#00, 16#08, 16#00,
       16#00, 16#00, 16#03, 16#40, 16#10, 16#92, 16#00, 16#01,
       16#00, 16#01, 16#00, 16#00, 16#02, 16#40, 16#02, 16#04,
       16#20, 16#00, 16#42, 16#00, 16#0a, 16#18, 16#40, 16#00,
       16#00, 16#00, 16#60, 16#40, 16#00, 16#00, 16#00, 16#00,
       16#35, 16#00, 16#12, 16#00, 16#00, 16#1b, 16#00, 16#0d,
       16#00, 16#1f,
       TLA/bytes, %% transportLayerAddress (IPv4)
       TEID:32/big, %% GTP-TEID
       16#00, 16#05, 16#04, 16#00, 16#68, 16#00,
       16#04, 16#03, 16#12, 16#34, 16#56, 16#00, 16#6b, 16#00,
       16#05, 16#1c, 16#00, 16#0e, 16#00, 16#00, 16#00, 16#28,
       16#00, 16#21, 16#28, 16#e0, 16#3f, 16#02, 16#35, 16#f1,
       16#1e, 16#13, 16#68, 16#a8, 16#55, 16#04, 16#db, 16#fb,
       16#8f, 16#65, 16#2b, 16#8c, 16#c7, 16#1c, 16#7c, 16#87,
       16#cc, 16#f3, 16#f6, 16#4d, 16#4f, 16#84, 16#5e, 16#e1,
       16#d2, 16#fc, 16#c6
    >>.


%% [eNB -> MME] HANDOVER REQUEST ACKNOWLEDGE
handover_request_ack_pdu(TLA, TEID) when is_binary(TLA),
                                         is_integer(TEID) ->
    << 16#20, 16#01, 16#00, 16#2c, 16#00, 16#00, 16#04, 16#00,
       16#00, 16#40, 16#03, 16#40, 16#10, 16#92, 16#00, 16#08,
       16#40, 16#02, 16#00, 16#00, 16#00, 16#12, 16#40, 16#10,
       16#00, 16#00, 16#14, 16#40, 16#0b, 16#00, 16#01, 16#f0,
       TLA/bytes, %% transportLayerAddress (IPv4)
       TEID:32/big, %% GTP-TEID
       16#00, 16#7b, 16#00, 16#04, 16#03, 16#12, 16#34, 16#56
    >>.


%% vim:set ts=4 sw=4 et:
